/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.compat.StarcatcherEmiPlugin;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StarcatcherEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiStack> output;
    private final TrophyProperties tp;
    private final List<EmiIngredient> input = List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.GUIDE})), EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ModItems.ROD})));
    private final ItemStack is;

    public StarcatcherEmiRecipe(ResourceLocation id, FishProperties fp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)fp.catchInfo().fish().value())));
        this.id = id;
        this.tp = null;
        this.is = new ItemStack(fp.catchInfo().fish());
    }

    public StarcatcherEmiRecipe(ResourceLocation id, TrophyProperties tp) {
        this.output = List.of(EmiStack.of((ItemLike)((ItemLike)tp.fish().value())));
        this.id = id;
        this.tp = tp;
        this.is = new ItemStack(tp.fish());
        ModDataComponents.set(this.is, ModDataComponents.TROPHY, this.tp);
    }

    public EmiRecipeCategory getCategory() {
        return StarcatcherEmiPlugin.STARCATCHER_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return Starcatcher.rl("/" + this.id.getPath());
    }

    public List<EmiIngredient> getInputs() {
        return List.of();
    }

    public List<EmiIngredient> getCatalysts() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 22;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.input.get(0), 5, 2);
        widgets.addSlot(this.input.get(1), 23, 2);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 45, 2);
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.is})), 73, 2).recipeContext((EmiRecipe)this);
    }
}

