/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.compat.StarcatcherEmiRecipe;
import com.wdiscute.starcatcher.compat.StarcatcherEmiSmithingRecipe;
import com.wdiscute.starcatcher.recipe.FishingRodSmithingRecipe;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;

@EmiEntrypoint
public class StarcatcherEmiPlugin
implements EmiPlugin {
    public static final ResourceLocation MY_SPRITE_SHEET = Starcatcher.rl("textures/gui/emi_simplified_textures.png");
    public static final EmiStack MY_WORKSTATION = EmiStack.of(ModItems.ROD);
    public static final EmiRecipeCategory STARCATCHER_CATEGORY = new EmiRecipeCategory(Starcatcher.rl("fishing"), (EmiRenderable)MY_WORKSTATION);

    public void register(EmiRegistry registry) {
        registry.addCategory(STARCATCHER_CATEGORY);
        registry.addWorkstation(STARCATCHER_CATEGORY, (EmiIngredient)MY_WORKSTATION);
        Registry fps = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY);
        for (FishProperties fp : fps) {
            registry.addRecipe((EmiRecipe)new StarcatcherEmiRecipe(fps.getKey((Object)fp), fp));
        }
        Registry trophies = Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY);
        for (TrophyProperties fp : trophies) {
            if (!fp.trophyType().equals((Object)TrophyProperties.TrophyType.TROPHY) && !fp.trophyType().equals((Object)TrophyProperties.TrophyType.SECRET)) continue;
            registry.addRecipe((EmiRecipe)new StarcatcherEmiRecipe(trophies.getKey((Object)fp), fp));
        }
        for (SmithingRecipe recipe : StarcatcherEmiPlugin.getRecipes(registry, RecipeType.SMITHING)) {
            if (!(recipe instanceof FishingRodSmithingRecipe)) continue;
            FishingRodSmithingRecipe frsr = (FishingRodSmithingRecipe)recipe;
            if (!Arrays.stream(((FishingRodSmithingRecipe)recipe).template().getItems()).anyMatch(o -> o.is(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE))) continue;
            registry.addRecipe((EmiRecipe)new StarcatcherEmiSmithingRecipe(frsr));
        }
        for (Holder item : (HolderSet.Named)BuiltInRegistries.ITEM.getTag(StarcatcherTags.TEMPLATES).get()) {
            registry.addRecipe((EmiRecipe)new StarcatcherEmiSmithingRecipe((Item)item.value()));
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        registry.addRecipe(supplier.get());
    }

    private static <C extends RecipeInput, T extends Recipe<C>> Iterable<T> getRecipes(EmiRegistry registry, RecipeType<T> type) {
        return registry.getRecipeManager().getAllRecipesFor(type).stream().map(e -> e.value())::iterator;
    }
}

