/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.compat;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.wdiscute.starcatcher.storage.FishProperties;
import net.minecraft.world.level.Level;

public class EclipticSeasonsCompat {
    public static boolean canCatch(FishProperties fp, Level level) {
        if (!fp.wr().seasons().contains((Object)FishProperties.WorldRestrictions.Seasons.ALL)) {
            return fp.wr().seasons().contains((Object)EclipticSeasonsCompat.getSeason(level)) || fp.wr().seasons().contains((Object)EclipticSeasonsCompat.getSubSeason(level));
        }
        return true;
    }

    public static FishProperties.WorldRestrictions.Seasons getSeason(Level level) {
        Season season = EclipticUtil.getNowSolarTerm((Level)level).getSeason();
        return switch (season) {
            case Season.NONE -> FishProperties.WorldRestrictions.Seasons.ALL;
            case Season.SPRING -> FishProperties.WorldRestrictions.Seasons.SPRING;
            case Season.SUMMER -> FishProperties.WorldRestrictions.Seasons.SUMMER;
            case Season.AUTUMN -> FishProperties.WorldRestrictions.Seasons.AUTUMN;
            default -> FishProperties.WorldRestrictions.Seasons.WINTER;
        };
    }

    public static FishProperties.WorldRestrictions.Seasons getSubSeason(Level level) {
        SolarTerm season = EclipticUtil.getNowSolarTerm((Level)level);
        return switch (season) {
            default -> throw new MatchException(null, null);
            case SolarTerm.NONE -> FishProperties.WorldRestrictions.Seasons.ALL;
            case SolarTerm.BEGINNING_OF_SPRING, SolarTerm.RAIN_WATER -> FishProperties.WorldRestrictions.Seasons.EARLY_SPRING;
            case SolarTerm.INSECTS_AWAKENING, SolarTerm.SPRING_EQUINOX -> FishProperties.WorldRestrictions.Seasons.MID_SPRING;
            case SolarTerm.FRESH_GREEN, SolarTerm.GRAIN_RAIN -> FishProperties.WorldRestrictions.Seasons.LATE_SPRING;
            case SolarTerm.BEGINNING_OF_SUMMER, SolarTerm.LESSER_FULLNESS -> FishProperties.WorldRestrictions.Seasons.EARLY_SUMMER;
            case SolarTerm.GRAIN_IN_EAR, SolarTerm.SUMMER_SOLSTICE -> FishProperties.WorldRestrictions.Seasons.MID_SUMMER;
            case SolarTerm.LESSER_HEAT, SolarTerm.GREATER_HEAT -> FishProperties.WorldRestrictions.Seasons.LATE_SUMMER;
            case SolarTerm.BEGINNING_OF_AUTUMN, SolarTerm.END_OF_HEAT -> FishProperties.WorldRestrictions.Seasons.EARLY_AUTUMN;
            case SolarTerm.WHITE_DEW, SolarTerm.AUTUMNAL_EQUINOX -> FishProperties.WorldRestrictions.Seasons.MID_AUTUMN;
            case SolarTerm.COLD_DEW, SolarTerm.FIRST_FROST -> FishProperties.WorldRestrictions.Seasons.LATE_AUTUMN;
            case SolarTerm.BEGINNING_OF_WINTER, SolarTerm.LIGHT_SNOW -> FishProperties.WorldRestrictions.Seasons.EARLY_WINTER;
            case SolarTerm.HEAVY_SNOW, SolarTerm.WINTER_SOLSTICE -> FishProperties.WorldRestrictions.Seasons.MID_WINTER;
            case SolarTerm.LESSER_COLD, SolarTerm.GREATER_COLD -> FishProperties.WorldRestrictions.Seasons.LATE_WINTER;
        };
    }
}

