/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FishingStartedPayload;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import com.wdiscute.starcatcher.registry.custom.tackleskin.AbstractTackleSkin;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ModCommands {
    private static final DynamicCommandExceptionType ERROR_ROD = new DynamicCommandExceptionType(o -> Component.translatableEscape((String)"commands.starcatcher.rod_not_found", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_EMPTY = new DynamicCommandExceptionType(o -> Component.translatableEscape((String)"commands.starcatcher.rod_not_found", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_FISH_ENTRY_INVALID = new DynamicCommandExceptionType(o -> Component.translatableEscape((String)"commands.starcatcher.fish_entry_not_found", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_MODIFIER_INVALID = new DynamicCommandExceptionType(o -> Component.translatableEscape((String)"commands.starcatcher.modifier_not_found", (Object[])new Object[]{o}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"starcatcher").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"simulate_fish").then(Commands.argument((String)"fish_entry", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.FISH_REGISTRY)).executes(c -> ModCommands.startMinigame(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<FishProperties>)((ResourceKey)ResourceArgument.getResource((CommandContext)c, (String)"fish_entry", Starcatcher.FISH_REGISTRY).unwrap().left().get())))))).then(Commands.literal((String)"add_minigame_modifier").then(Commands.argument((String)"modifier", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.MINIGAME_MODIFIERS)).executes(c -> ModCommands.addMinigameModifier(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<Supplier<AbstractMinigameModifier>>)((ResourceKey)ResourceArgument.getResource((CommandContext)c, (String)"modifier", Starcatcher.MINIGAME_MODIFIERS).unwrap().left().get())))))).then(Commands.literal((String)"add_catch_modifier").then(Commands.argument((String)"modifier", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.CATCH_MODIFIERS)).executes(c -> ModCommands.addCatchModifier(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<Supplier<AbstractCatchModifier>>)((ResourceKey)ResourceArgument.getResource((CommandContext)c, (String)"modifier", Starcatcher.CATCH_MODIFIERS).unwrap().left().get())))))).then(Commands.literal((String)"add_tackle_skin").then(Commands.argument((String)"modifier", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.TACKLE_SKIN)).executes(c -> ModCommands.addTackleSkin(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<Supplier<AbstractTackleSkin>>)((ResourceKey)ResourceArgument.getResource((CommandContext)c, (String)"modifier", Starcatcher.TACKLE_SKIN).unwrap().left().get())))))).then(Commands.literal((String)"remove_minigame_modifier").executes(c -> ModCommands.removeMinigameModifier(((CommandSourceStack)c.getSource()).getPlayerOrException())))).then(Commands.literal((String)"remove_catch_modifier").executes(c -> ModCommands.removeCatchModifier(((CommandSourceStack)c.getSource()).getPlayerOrException())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"award_fish").executes(c -> ModCommands.awardAllFish(((CommandSourceStack)c.getSource()).getPlayerOrException()))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").executes(c -> ModCommands.awardAllFish(((CommandSourceStack)c.getSource()).getPlayerOrException()))).then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"weight", (ArgumentType)IntegerArgumentType.integer()).executes(c -> ModCommands.awardAllFish(((CommandSourceStack)c.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), IntegerArgumentType.getInteger((CommandContext)c, (String)"size"), IntegerArgumentType.getInteger((CommandContext)c, (String)"weight")))))))).then(((RequiredArgumentBuilder)Commands.argument((String)"fish", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.FISH_REGISTRY)).executes(c -> ModCommands.awardFish(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<FishProperties>)((ResourceKey)ResourceArgument.getResource((CommandContext)c, (String)"fish", Starcatcher.FISH_REGISTRY).unwrap().left().get()), 0, 0, 0))).then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"weight", (ArgumentType)IntegerArgumentType.integer()).executes(c -> ModCommands.awardFish(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<FishProperties>)ResourceArgument.getResource((CommandContext)c, (String)"fish", Starcatcher.FISH_REGISTRY).key(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), IntegerArgumentType.getInteger((CommandContext)c, (String)"size"), IntegerArgumentType.getInteger((CommandContext)c, (String)"weight"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"revoke_fish").executes(c -> ModCommands.revokeAllFish(((CommandSourceStack)c.getSource()).getPlayerOrException()))).then(Commands.literal((String)"all").executes(c -> ModCommands.revokeAllFish(((CommandSourceStack)c.getSource()).getPlayerOrException())))).then(Commands.argument((String)"fish", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, Starcatcher.FISH_REGISTRY)).executes(c -> ModCommands.revokeFish(((CommandSourceStack)c.getSource()).getPlayerOrException(), (ResourceKey<FishProperties>)ResourceArgument.getResource((CommandContext)c, (String)"fish", Starcatcher.FISH_REGISTRY).key())))));
    }

    private static int revokeAllFish(ServerPlayer player) {
        FishingGuideAttachment.getFishesCaught((Player)player).clear();
        FishingGuideAttachment.sync((Player)player);
        return 0;
    }

    private static int revokeFish(ServerPlayer player, ResourceKey<FishProperties> fish) {
        FishingGuideAttachment.getFishesCaught((Player)player).remove(fish.location());
        FishingGuideAttachment.sync((Player)player);
        return 0;
    }

    private static int awardAllFish(ServerPlayer player, int ticks, int size, int weight) {
        for (FishProperties fp : player.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            FishCaughtCounter.awardFishCaughtCounter(fp, (Player)player, ticks, size, weight, false, false);
        }
        return 0;
    }

    private static int awardAllFish(ServerPlayer player) {
        for (FishProperties fp : player.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            FishCaughtCounter.awardFishCaughtCounter(fp, (Player)player, 0, 0, 0, false, false);
        }
        return 0;
    }

    private static int awardFish(ServerPlayer player, ResourceKey<FishProperties> fish, int ticks, int size, int weight) throws CommandSyntaxException {
        Optional optional = player.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).getOptional(fish);
        if (!optional.isPresent()) {
            throw ERROR_FISH_ENTRY_INVALID.create(fish);
        }
        FishCaughtCounter.awardFishCaughtCounter((FishProperties)optional.get(), (Player)player, ticks, size, weight, false, false);
        return 0;
    }

    private static int removeMinigameModifier(ServerPlayer player) throws CommandSyntaxException {
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            throw ERROR_EMPTY.create(null);
        }
        if (ModDataComponents.has(stack, ModDataComponents.MINIGAME_MODIFIERS)) {
            ModDataComponents.remove(stack, ModDataComponents.MINIGAME_MODIFIERS);
        }
        return 1;
    }

    private static int removeCatchModifier(ServerPlayer player) throws CommandSyntaxException {
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            throw ERROR_EMPTY.create(null);
        }
        if (ModDataComponents.has(stack, ModDataComponents.CATCH_MODIFIERS)) {
            ModDataComponents.remove(stack, ModDataComponents.CATCH_MODIFIERS);
        }
        return 1;
    }

    private static int addMinigameModifier(ServerPlayer player, ResourceKey<Supplier<AbstractMinigameModifier>> modifier) throws CommandSyntaxException {
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            throw ERROR_EMPTY.create(null);
        }
        if (ModDataComponents.has(stack, ModDataComponents.MINIGAME_MODIFIERS)) {
            ArrayList<ResourceLocation> mods = new ArrayList<ResourceLocation>((Collection)ModDataComponents.get(stack, ModDataComponents.MINIGAME_MODIFIERS));
            mods.add(modifier.location());
            ModDataComponents.set(stack, ModDataComponents.MINIGAME_MODIFIERS, mods);
        } else {
            ModDataComponents.set(stack, ModDataComponents.MINIGAME_MODIFIERS, List.of(modifier.location()));
        }
        return 1;
    }

    private static int addCatchModifier(ServerPlayer player, ResourceKey<Supplier<AbstractCatchModifier>> modifier) throws CommandSyntaxException {
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            throw ERROR_EMPTY.create(null);
        }
        if (ModDataComponents.has(stack, ModDataComponents.CATCH_MODIFIERS)) {
            ArrayList<ResourceLocation> mods = new ArrayList<ResourceLocation>((Collection)ModDataComponents.get(stack, ModDataComponents.CATCH_MODIFIERS));
            mods.add(modifier.location());
            ModDataComponents.set(stack, ModDataComponents.CATCH_MODIFIERS, mods);
        } else {
            ModDataComponents.set(stack, ModDataComponents.CATCH_MODIFIERS, List.of(modifier.location()));
        }
        return 1;
    }

    private static int addTackleSkin(ServerPlayer player, ResourceKey<Supplier<AbstractTackleSkin>> tackleSkin) throws CommandSyntaxException {
        ItemStack stack = player.getMainHandItem();
        if (!stack.is(StarcatcherTags.RODS)) {
            throw ERROR_ROD.create(null);
        }
        ModDataComponents.set(stack, ModDataComponents.TACKLE_SKIN, tackleSkin.location());
        return 1;
    }

    private static int startMinigame(ServerPlayer player, ResourceKey<FishProperties> fish) throws CommandSyntaxException {
        if (!player.getMainHandItem().is(StarcatcherTags.RODS)) {
            throw ERROR_ROD.create(null);
        }
        Optional optional = player.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).getOptional(fish);
        if (optional.isPresent()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new FishingStartedPayload((FishProperties)optional.get(), player.getMainHandItem()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        }
        throw ERROR_FISH_ENTRY_INVALID.create((Object)fish.location());
    }
}

