/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.bob;

import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.io.attachments.FishingBobAttachment;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FishingStartedPayload;
import com.wdiscute.starcatcher.registry.ModEntities;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.ModParticles;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.ModCatchModifiers;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ModTackleSkins;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishingBobEntity
extends Projectile {
    private static final Logger log = LoggerFactory.getLogger(FishingBobEntity.class);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(FishingBobEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final Player player;
    private FishHookState currentState;
    public FishProperties fpToFish;
    public ItemStack rod = ItemStack.EMPTY;
    public final List<AbstractCatchModifier> modifiers;
    public boolean netherite_upgraded = false;
    public int minTicksToFish;
    public int maxTicksToFish;
    public int chanceToFishEachTick;
    public int timeBiting;
    public int ticksInFluid;

    public FishingBobEntity(EntityType<? extends FishingBobEntity> entityType, Level level) {
        super(entityType, level);
        this.player = null;
        this.modifiers = ModCatchModifiers.getAllCatchModifiers(level, this.rod);
        this.modifiers.forEach(acm -> acm.onAdd(this));
    }

    public FishingBobEntity(Level level, Player player, ItemStack rod) {
        super(ModEntities.FISHING_BOB.get(), level);
        this.setOwner((Entity)player);
        this.player = player;
        this.rod = rod;
        this.modifiers = ModCatchModifiers.getAllCatchModifiers(level, rod);
        this.netherite_upgraded = ModDataComponents.getOrDefault(rod, ModDataComponents.NETHERITE_UPGRADE, false);
        this.minTicksToFish = 100;
        this.maxTicksToFish = 300;
        this.chanceToFishEachTick = 100;
        for (AbstractCatchModifier acm2 : this.modifiers) {
            this.minTicksToFish = acm2.adjustMinTicksToFish(this.minTicksToFish);
            this.maxTicksToFish = acm2.adjustMaxTicksToFish(this.maxTicksToFish);
            this.chanceToFishEachTick = acm2.adjustChanceToFishEachTick(this.chanceToFishEachTick);
        }
        this.modifiers.forEach(acm -> acm.onAdd(this));
        float playerXRot = player.getXRot();
        float playerYRot = player.getYRot();
        float f2 = Mth.cos((float)(-playerYRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-playerYRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-playerXRot * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-playerXRot * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, playerYRot, playerXRot);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        if (!level.isClientSide) {
            ((FishingBobAttachment)ModDataAttachments.get((Entity)player, ModDataAttachments.FISHING_BOB)).setUuid((AttachmentHolder)player, this.uuid);
        }
        this.currentState = FishHookState.FLYING;
    }

    public void reel() {
        this.modifiers.forEach(AbstractCatchModifier::onReelStart);
        List<FishProperties> available = new ArrayList<FishProperties>(List.of());
        Map<ResourceLocation, Integer> data = FishingGuideAttachment.getTrophiesCaught(this.player);
        ArrayList<TrophyProperties> trophiesCaught = new ArrayList<TrophyProperties>(U.getTpsFromRls(this.level(), data.keySet().stream().toList()));
        AtomicReference<TrophyProperties.RarityProgress> all = new AtomicReference<TrophyProperties.RarityProgress>(TrophyProperties.RarityProgress.fromAttachment(this.player));
        EnumMap<FishProperties.Rarity, TrophyProperties.RarityProgress> progressMap = new EnumMap<FishProperties.Rarity, TrophyProperties.RarityProgress>(Map.of(FishProperties.Rarity.COMMON, new TrophyProperties.RarityProgress(0, -1), FishProperties.Rarity.UNCOMMON, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.RARE, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.EPIC, TrophyProperties.RarityProgress.DEFAULT, FishProperties.Rarity.LEGENDARY, TrophyProperties.RarityProgress.DEFAULT));
        FishingGuideAttachment.getFishesCaught(this.player).forEach((loc, counter) -> {
            all.set(new TrophyProperties.RarityProgress(((TrophyProperties.RarityProgress)all.get()).total() + counter.count(), ((TrophyProperties.RarityProgress)all.get()).unique()));
            progressMap.computeIfPresent(U.getFpFromRl(this.level(), loc).rarity(), (r, p) -> new TrophyProperties.RarityProgress(p.total() + counter.count(), p.unique() + 1));
        });
        block0: for (TrophyProperties tp : this.level().registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            for (FishProperties.Rarity value : FishProperties.Rarity.values()) {
                if (!FishingBobEntity.check((TrophyProperties.RarityProgress)progressMap.get((Object)value), tp.getProgress(value))) continue block0;
            }
            if (!FishingBobEntity.check(all.get(), tp.all()) || trophiesCaught.contains(tp) || FishProperties.getChance(tp.fp(), (Entity)this, this.rod) <= 0 || this.random.nextIntBetweenInclusive(0, 99) >= tp.chanceToCatch()) continue;
            ItemStack is = new ItemStack((ItemLike)tp.fish().value());
            ModDataComponents.set(is, ModDataComponents.TROPHY, tp);
            ItemEntity itemFished = new ItemEntity(this.level(), this.position().x, this.position().y + (double)1.2f, this.position().z, is);
            Vec3 vec3 = new Vec3(Math.clamp((this.player.position().x - this.position().x) / 25.0, -1.0, 1.0), 0.7 + Math.clamp((this.player.position().y - this.position().y) / 20.0, -1.0, 1.0), Math.clamp((this.player.position().z - this.position().z) / 25.0, -1.0, 1.0));
            itemFished.setDeltaMovement(vec3);
            this.level().addFreshEntity((Entity)itemFished);
            trophiesCaught.add(tp);
            U.getRlsFromTps(this.level(), trophiesCaught).forEach(loc -> data.putIfAbsent((ResourceLocation)loc, 0));
            this.kill();
            return;
        }
        this.modifiers.forEach(AbstractCatchModifier::onReelAfterTreasureCheck);
        for (FishProperties fp : this.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            int chance = FishProperties.getChance(fp, (Entity)this, this.rod);
            for (int i = 0; i < chance; ++i) {
                available.add(fp);
            }
        }
        if (available.isEmpty()) {
            this.kill();
        }
        for (AbstractCatchModifier acm2 : this.modifiers) {
            available = acm2.modifyAvailablePool(available);
        }
        this.fpToFish = (FishProperties)available.get(this.random.nextInt(available.size()));
        List<FishProperties> immutableAvailable = available;
        this.modifiers.forEach(acm -> acm.afterChoosingTheCatch(immutableAvailable));
        if (this.modifiers.stream().anyMatch(AbstractCatchModifier::shouldCancelBeforeSkipsMinigameCheck)) {
            this.kill();
            return;
        }
        if (this.fpToFish.skipMinigame() || !((Boolean)Config.ENABLE_MINIGAME.get()).booleanValue() || this.modifiers.stream().anyMatch(m -> m.forceSkipMinigame((Boolean)Config.ENABLE_MINIGAME.get()))) {
            U.spawnFishFromPlayerFishing((ServerPlayer)this.player, 0, false, false, 0);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new FishingStartedPayload(this.fpToFish, this.rod), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        ItemStack bait = ((SingleStackContainer)ModDataComponents.get(this.rod, ModDataComponents.BAIT)).stack().copy();
        if (this.fpToFish.br().consumesBait()) {
            if (!bait.is(Items.BUCKET)) {
                bait.shrink(1);
                ModDataComponents.set(this.rod, ModDataComponents.BAIT, new SingleStackContainer(bait));
                return;
            }
            if (bait.is(Items.BUCKET) && !this.fpToFish.catchInfo().bucketedFish().is(ModItems.MISSINGNO.getKey())) {
                bait.shrink(1);
                ModDataComponents.set(this.rod, ModDataComponents.BAIT, new SingleStackContainer(bait));
            }
        }
    }

    private boolean shouldStopFishing(Player player) {
        boolean holdingRod;
        if (this.level().isClientSide) {
            return false;
        }
        if (this.modifiers.stream().anyMatch(acm -> acm.shouldStopFishing())) {
            return true;
        }
        boolean bl = holdingRod = player.getMainHandItem().is(StarcatcherTags.RODS) || player.getOffhandItem().is(StarcatcherTags.RODS);
        if (!player.isRemoved() && player.isAlive() && holdingRod && !(this.distanceToSqr((Entity)player) > 1024.0)) {
            return false;
        }
        this.kill();
        return true;
    }

    public boolean fireImmune() {
        return this.netherite_upgraded;
    }

    public void lavaHurt() {
        super.lavaHurt();
        if (!this.netherite_upgraded && !this.level().isClientSide) {
            this.kill();
        }
    }

    public void kill() {
        ModDataAttachments.remove((Entity)this.player, ModDataAttachments.FISHING_BOB);
        super.kill();
    }

    public void tick() {
        Player player;
        super.tick();
        if (!this.level().isClientSide) {
            if (this.currentState == FishHookState.FLYING) {
                this.entityData.set(STATE, (Object)1);
            }
            if (this.currentState == FishHookState.BOBBING) {
                this.entityData.set(STATE, (Object)2);
            }
            if (this.currentState == FishHookState.BITING) {
                this.entityData.set(STATE, (Object)3);
            }
            if (this.currentState == FishHookState.FISHING) {
                this.entityData.set(STATE, (Object)4);
            }
        } else {
            if ((Integer)this.entityData.get(STATE) == 1) {
                this.currentState = FishHookState.FLYING;
            }
            if ((Integer)this.entityData.get(STATE) == 2) {
                this.currentState = FishHookState.BOBBING;
            }
            if ((Integer)this.entityData.get(STATE) == 3) {
                this.currentState = FishHookState.BITING;
            }
            if ((Integer)this.entityData.get(STATE) == 4) {
                this.currentState = FishHookState.FISHING;
            }
        }
        if ((player = (Player)this.getOwner()) == null || this.shouldStopFishing(player)) {
            this.discard();
            if (player != null) {
                ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHING_BOB);
            }
        }
        BlockPos blockpos = this.blockPosition();
        FluidState fluid = this.level().getFluidState(blockpos);
        FluidState fluidBellow = this.level().getFluidState(blockpos.below());
        if (this.currentState == FishHookState.FLYING) {
            if (this.getDeltaMovement().y < (double)1.2f) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
            }
            if (!fluid.isEmpty()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.3, 0.3));
                if (!this.level().isClientSide) {
                    this.currentState = FishHookState.BOBBING;
                }
                return;
            }
        }
        if (this.currentState == FishHookState.BITING) {
            ++this.timeBiting;
            for (int i = 0; i < 5; ++i) {
                if (this.level().getFluidState(blockpos).is((Fluid)Fluids.LAVA)) {
                    this.level().addParticle((ParticleOptions)ModParticles.FISHING_BITING_LAVA.get(), this.position().x + (double)this.random.nextFloat() - 0.5, this.position().y + (double)this.random.nextFloat() * 0.5 - 0.25, this.position().z + (double)this.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                    continue;
                }
                this.level().addParticle((ParticleOptions)ModParticles.FISHING_BITING.get(), this.position().x + (double)this.random.nextFloat() - 0.5, this.position().y + (double)this.random.nextFloat() * 0.5 - 0.25, this.position().z + (double)this.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
            if (this.timeBiting > 80) {
                ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHING_BOB);
                ModTackleSkins.get(this.level(), this.rod).onMissed(player);
                this.kill();
            }
        } else {
            this.timeBiting = 0;
        }
        if (fluid.isEmpty() && fluidBellow.isEmpty() && !this.level().isClientSide) {
            this.currentState = FishHookState.FLYING;
        }
        if (this.currentState == FishHookState.BOBBING || this.currentState == FishHookState.FISHING) {
            this.checkForFish();
            if (!fluid.isEmpty()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
            } else if ((double)this.random.nextFloat() > 0.02) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.01, 0.0));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround() || this.horizontalCollision) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        this.reapplyPosition();
    }

    public boolean checkBiting() {
        if (this.currentState == FishHookState.BITING) {
            this.currentState = FishHookState.FISHING;
            this.reel();
            return true;
        }
        return false;
    }

    private void checkForFish() {
        if (!this.level().isClientSide && this.currentState == FishHookState.BOBBING) {
            ++this.ticksInFluid;
            int i = this.random.nextInt(this.chanceToFishEachTick);
            if ((i == 1 || this.ticksInFluid > this.maxTicksToFish) && this.ticksInFluid > this.minTicksToFish) {
                if (((Boolean)Config.SHOW_EXCLAMATION_MARK_PARTICLE.get()).booleanValue()) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ModParticles.FISHING_NOTIFICATION.get(), this.position().x, this.position().y + 1.0, this.position().z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.setPos(this.position().x, this.position().y - 0.5, this.position().z);
                if (!this.level().isClientSide) {
                    this.currentState = FishHookState.BITING;
                }
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            }
        }
    }

    public AABB getBoundingBoxForCulling() {
        AABB box = new AABB(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0);
        return box.move(this.position());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STATE, (Object)0);
    }

    public static boolean check(TrophyProperties.RarityProgress current, TrophyProperties.RarityProgress restriction) {
        return current.total() >= restriction.total() && current.unique() >= restriction.unique();
    }

    static enum FishHookState {
        FLYING,
        BOBBING,
        BITING,
        FISHING;

    }
}

