/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import com.mojang.logging.LogUtils;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.guide.FishCaughtToast;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.registry.ModCreativeModeTabs;
import com.wdiscute.starcatcher.registry.ModCriterionTriggers;
import com.wdiscute.starcatcher.registry.ModEntities;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.ModMenuTypes;
import com.wdiscute.starcatcher.registry.ModParticles;
import com.wdiscute.starcatcher.registry.ModRecipes;
import com.wdiscute.starcatcher.registry.ModSounds;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.registry.blocks.ModBlocks;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.ModCatchModifiers;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.ModMinigameModifiers;
import com.wdiscute.starcatcher.registry.custom.sweetspotbehaviour.AbstractSweetSpotBehaviour;
import com.wdiscute.starcatcher.registry.custom.sweetspotbehaviour.ModSweetSpotsBehaviour;
import com.wdiscute.starcatcher.registry.custom.tackleskin.AbstractTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ModTackleSkins;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.slf4j.Logger;

@Mod(value="starcatcher")
public class Starcatcher {
    public static final String MOD_ID = "starcatcher";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Registry<FishProperties>> FISH_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("fish"));
    public static final ResourceKey<Registry<TrophyProperties>> TROPHY_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("trophy"));
    public static final ResourceKey<Registry<Supplier<? extends AbstractSweetSpotBehaviour>>> SWEET_SPOT_BEHAVIOUR = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("sweet_spot_behaviour"));
    public static final ResourceKey<Registry<Supplier<AbstractMinigameModifier>>> MINIGAME_MODIFIERS = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("minigame_modifiers"));
    public static final ResourceKey<Registry<Supplier<AbstractCatchModifier>>> CATCH_MODIFIERS = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("catch_modifiers"));
    public static final ResourceKey<Registry<Supplier<AbstractTackleSkin>>> TACKLE_SKIN = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("bobber_skin"));
    public static final Registry<Supplier<? extends AbstractSweetSpotBehaviour>> SWEET_SPOT_BEHAVIOUR_REGISTRY = new RegistryBuilder(SWEET_SPOT_BEHAVIOUR).sync(true).defaultKey(Starcatcher.rl("normal")).create();
    public static final Registry<Supplier<AbstractMinigameModifier>> MINIGAME_MODIFIERS_REGISTRY = new RegistryBuilder(MINIGAME_MODIFIERS).sync(true).defaultKey(Starcatcher.rl("slower_vanishing")).create();
    public static final Registry<Supplier<AbstractCatchModifier>> CATCH_MODIFIERS_REGISTRY = new RegistryBuilder(CATCH_MODIFIERS).sync(true).defaultKey(Starcatcher.rl("decrease_lure_time")).create();
    public static final Registry<Supplier<AbstractTackleSkin>> TACKLE_SKIN_REGISTRY = new RegistryBuilder(TACKLE_SKIN).sync(true).defaultKey(Starcatcher.rl("pearl")).create();

    public static double truncatedNormal(double mean, double deviation) {
        double value;
        while (!((value = mean + deviation * U.r.nextGaussian()) >= mean - deviation) || !(value <= mean + deviation)) {
        }
        return value;
    }

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fishCaughtToast(FishProperties fp, boolean newFish, int sizeCM, int weightCM) {
        if (newFish) {
            Minecraft.getInstance().getToasts().addToast((Toast)new FishCaughtToast(fp));
        }
        SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
        String size = units.getSizeAsString(sizeCM);
        String weight = units.getWeightAsString(weightCM);
        Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"").append((Component)Component.translatable((String)((Item)fp.catchInfo().fish().value()).getDescriptionId())).append((Component)Component.literal((String)(" - " + size + " - " + weight))), true);
        Minecraft.getInstance().gui.overlayMessageTime = 180;
    }

    public Starcatcher(IEventBus modEventBus, ModContainer modContainer) {
        ModCreativeModeTabs.register(modEventBus);
        ModItems.ITEMS_REGISTRY.register(modEventBus);
        ModItems.BAITS_REGISTRY.register(modEventBus);
        ModItems.HOOKS_REGISTRY.register(modEventBus);
        ModItems.BOBBERS_REGISTRY.register(modEventBus);
        ModItems.FISH_REGISTRY.register(modEventBus);
        ModItems.KINDA_BUT_NOT_REALLY_FISH_REGISTRY.register(modEventBus);
        ModItems.TRASH_REGISTRY.register(modEventBus);
        ModItems.BLOCKITEMS_REGISTRY.register(modEventBus);
        ModItems.RODS_REGISTRY.register(modEventBus);
        ModItems.TEMPLATES_REGISTRY.register(modEventBus);
        ModItems.DEV_REGISTRY.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModParticles.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModDataAttachments.register(modEventBus);
        ModSweetSpotsBehaviour.register(modEventBus);
        ModMinigameModifiers.register(modEventBus);
        ModCatchModifiers.register(modEventBus);
        ModTackleSkins.register(modEventBus);
        ModCriterionTriggers.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC_SERVER);
        ModItems.registerExtra();
    }
}

