/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.world.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.valhelsia.valhelsia_core.core.registry.neoforge.ValhelsiaBiomeModifiers;

public record AddNetherSpawnsBiomeModifier(HolderSet<Biome> biomes, Optional<MobCategory> category, List<MobSpawnSettings.SpawnerData> spawners, double charge, double energyBudget) implements BiomeModifier
{
    public static final MapCodec<AddNetherSpawnsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(modifier -> modifier.biomes), (App)MobCategory.CODEC.optionalFieldOf("category").forGetter(modifier -> modifier.category), (App)Codec.either((Codec)MobSpawnSettings.SpawnerData.CODEC.listOf(), (Codec)MobSpawnSettings.SpawnerData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.getFirst())) : Either.left((Object)list)).fieldOf("spawners").forGetter(modifier -> modifier.spawners), (App)Codec.DOUBLE.fieldOf("charge").forGetter(modifier -> modifier.charge), (App)Codec.DOUBLE.fieldOf("energyBudget").forGetter(modifier -> modifier.energyBudget)).apply((Applicative)instance, AddNetherSpawnsBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                EntityType type = spawner.type;
                spawns.addSpawn(this.category.orElseGet(() -> ((EntityType)type).getCategory()), spawner);
                spawns.addMobCharge(type, this.charge, this.energyBudget);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return ValhelsiaBiomeModifiers.ADD_NETHER_SPAWNS.get();
    }
}

