/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render;

import net.minecraft.client.resources.language.I18n;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;

public enum ConfiguredColour {
    CUBOIDGRID("cuboidgrid", Colour.parseRgba("#CC4C4CCC")),
    CUBOIDBOX("cuboidedge", Colour.parseRgba("#CC3333CC")),
    CUBOIDPOINT1("cuboidpoint1", Colour.parseRgba("#33CC33CC")),
    CUBOIDPOINT2("cuboidpoint2", Colour.parseRgba("#3333CCCC")),
    POLYGRID("polygrid", Colour.parseRgba("#CC3333CC")),
    POLYBOX("polyedge", Colour.parseRgba("#CC4C4CCC")),
    POLYPOINT("polypoint", Colour.parseRgba("#33CCCCCC")),
    ELLIPSOIDGRID("ellipsoidgrid", Colour.parseRgba("#CC4C4CCC")),
    ELLIPSOIDCENTRE("ellipsoidpoint", Colour.parseRgba("#CCCC33CC")),
    CYLINDERGRID("cylindergrid", Colour.parseRgba("#CC3333CC")),
    CYLINDERBOX("cylinderedge", Colour.parseRgba("#CC4C4CCC")),
    CYLINDERCENTRE("cylinderpoint", Colour.parseRgba("#CC33CCCC")),
    CHUNKBOUNDARY("chunkboundary", Colour.parseRgba("#33CC33CC")),
    CHUNKGRID("chunkgrid", Colour.parseRgba("#4CCCAA99"));

    private final String displayName;
    private final Colour defaultColour;
    private Colour colour;
    private LineStyle normal;
    private LineStyle hidden;
    private LineStyle[] lines;

    private ConfiguredColour(String displayName, Colour colour) {
        this.displayName = displayName;
        this.colour = colour;
        this.defaultColour = colour;
        this.updateLines();
    }

    public String getDisplayName() {
        return I18n.get((String)("worldeditcui.color." + this.displayName), (Object[])new Object[0]);
    }

    public RenderStyle style() {
        return new Style();
    }

    public void setColour(Colour colour) {
        this.colour = colour;
        this.updateLines();
    }

    public Colour getColour() {
        return this.colour;
    }

    public LineStyle getHidden() {
        return this.hidden;
    }

    public LineStyle getNormal() {
        return this.normal;
    }

    public LineStyle[] getLines() {
        return this.lines;
    }

    public void setDefault() {
        this.colour = this.defaultColour;
        this.updateLines();
    }

    public Colour getDefault() {
        return this.defaultColour;
    }

    public void setColourIntRGBA(int argb) {
        this.colour = new Colour(argb);
        this.updateLines();
    }

    public int getColourIntARGB() {
        return this.colour.argb();
    }

    private void updateLines() {
        this.hidden = new LineStyle(RenderStyle.RenderType.HIDDEN, 3.0f, Math.round((float)this.colour.red() * 0.75f), Math.round((float)this.colour.green() * 0.75f), Math.round((float)this.colour.blue() * 0.75f), Math.round((float)this.colour.alpha() * 0.25f));
        this.normal = new LineStyle(RenderStyle.RenderType.VISIBLE, 3.0f, this.colour.red(), this.colour.green(), this.colour.blue(), this.colour.alpha());
        this.lines = new LineStyle[]{this.hidden, this.normal};
    }

    class Style
    implements RenderStyle {
        private RenderStyle.RenderType renderType = RenderStyle.RenderType.ANY;

        Style() {
        }

        @Override
        public void setRenderType(RenderStyle.RenderType renderType) {
            this.renderType = renderType;
        }

        @Override
        public RenderStyle.RenderType getRenderType() {
            return this.renderType;
        }

        @Override
        public void setColour(Colour colour) {
        }

        @Override
        public Colour getColour() {
            return ConfiguredColour.this.getColour();
        }

        @Override
        public LineStyle[] getLines() {
            return ConfiguredColour.this.getLines();
        }
    }
}

