/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.event.listeners.CUIListenerChannel;
import org.enginehub.worldeditcui.event.listeners.CUIListenerWorldRender;
import org.enginehub.worldeditcui.gui.CUIConfigPanel;
import org.enginehub.worldeditcui.neoforge.CUINetworking;
import org.enginehub.worldeditcui.neoforge.mixins.LevelRendererAccessor;
import org.enginehub.worldeditcui.render.OptifinePipelineProvider;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.VanillaPipelineProvider;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.MixinEnvironment;

@Mod(value="worldeditcui")
public final class NeoForgeModWorldEditCUI {
    private static final int DELAYED_HELO_TICKS = 10;
    public static final String MOD_ID = "worldeditcui";
    private static NeoForgeModWorldEditCUI instance;
    private static final String KEYBIND_CATEGORY_WECUI = "key.categories.worldeditcui";
    private final KeyMapping keyBindToggleUI = NeoForgeModWorldEditCUI.key("toggle", InputConstants.Type.KEYSYM, -1);
    private final KeyMapping keyBindClearSel = NeoForgeModWorldEditCUI.key("clear", InputConstants.Type.KEYSYM, -1);
    private final KeyMapping keyBindChunkBorder = NeoForgeModWorldEditCUI.key("chunk", InputConstants.Type.KEYSYM, -1);
    private static final List<PipelineProvider> RENDER_PIPELINES;
    private WorldEditCUI controller;
    private CUIListenerWorldRender worldRenderListener;
    private CUIListenerChannel channelListener;
    private Level lastWorld;
    private LocalPlayer lastPlayer;
    private boolean visible = true;
    private int delayedHelo = 0;

    private static KeyMapping key(String name, InputConstants.Type type, int code) {
        return new KeyMapping("key.worldeditcui." + name, type, code, KEYBIND_CATEGORY_WECUI);
    }

    public NeoForgeModWorldEditCUI(IEventBus eventBus, ModContainer container) {
        if (Boolean.getBoolean("wecui.debug.mixinaudit")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        instance = this;
        if (FMLEnvironment.dist.isClient()) {
            eventBus.register(ModEventBusListener.class);
            eventBus.register(CUINetworking.class);
            NeoForge.EVENT_BUS.register(ForgeEventBusListener.class);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, parent) -> new CUIConfigPanel(parent, instance.getController().getConfiguration())));
        }
    }

    private void onTick(Minecraft mc) {
        boolean clock;
        if (this.controller == null) {
            return;
        }
        CUIConfiguration config = this.controller.getConfiguration();
        boolean inGame = mc.player != null;
        boolean bl = clock = mc.getTimer().getGameTimeDeltaPartialTick(true) > 0.0f;
        if (inGame && mc.screen == null) {
            while (this.keyBindToggleUI.consumeClick()) {
                this.visible = !this.visible;
            }
            while (this.keyBindClearSel.consumeClick()) {
                if (mc.player != null) {
                    mc.player.connection.sendUnsignedCommand("/sel");
                }
                if (!config.isClearAllOnKey()) continue;
                this.controller.clearRegions();
            }
            while (this.keyBindChunkBorder.consumeClick()) {
                this.controller.toggleChunkBorders();
            }
        }
        if (inGame && clock) {
            if (mc.level != this.lastWorld || mc.player != this.lastPlayer) {
                this.lastWorld = mc.level;
                this.lastPlayer = mc.player;
                this.controller.getDebugger().debug("World change detected, sending new handshake");
                this.controller.clear();
                this.helo(mc.getConnection());
                this.delayedHelo = 10;
                if (mc.player != null && config.isPromiscuous()) {
                    mc.player.connection.sendUnsignedCommand("we cui");
                }
            }
            if (this.delayedHelo > 0) {
                --this.delayedHelo;
                if (this.delayedHelo == 0) {
                    this.helo(mc.getConnection());
                }
            }
        }
    }

    public void onPluginMessage(String stringPayload) {
        try {
            Minecraft.getInstance().execute(() -> this.channelListener.onMessage(stringPayload));
        }
        catch (Exception ex) {
            this.getController().getDebugger().info("Error decoding payload from server", ex);
        }
    }

    public void onGameInitDone(Minecraft client) {
        this.controller = new WorldEditCUI();
        this.controller.initialise(client);
        this.worldRenderListener = new CUIListenerWorldRender(this.controller, client, RENDER_PIPELINES);
        this.channelListener = new CUIListenerChannel(this.controller);
    }

    public void onJoinGame(ClientPacketListener handler) {
        this.visible = true;
        this.controller.getDebugger().debug("Joined game, sending initial handshake");
        this.helo(handler);
    }

    public void onPostRenderEntities(DeltaTracker timer) {
        if (this.visible) {
            this.worldRenderListener.onRender(timer.getGameTimeDeltaPartialTick(true));
        }
    }

    private void helo(ClientPacketListener handler) {
        String message = "v|4";
        CUINetworking.send(handler, "v|4");
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public static NeoForgeModWorldEditCUI getInstance() {
        return instance;
    }

    static {
        RENDER_PIPELINES = List.of(new OptifinePipelineProvider(), new VanillaPipelineProvider());
    }

    private static class ModEventBusListener {
        private ModEventBusListener() {
        }

        @SubscribeEvent
        private static void onRegisterKeyMapping(RegisterKeyMappingsEvent event) {
            event.register(NeoForgeModWorldEditCUI.instance.keyBindChunkBorder);
            event.register(NeoForgeModWorldEditCUI.instance.keyBindClearSel);
            event.register(NeoForgeModWorldEditCUI.instance.keyBindToggleUI);
        }

        @SubscribeEvent
        private static void onClientLifecycleClientStarted(FMLClientSetupEvent event) {
            instance.onGameInitDone(Minecraft.getInstance());
        }
    }

    private static class ForgeEventBusListener {
        private ForgeEventBusListener() {
        }

        @SubscribeEvent
        private static void onClientTickEnd(ClientTickEvent.Post event) {
            instance.onTick(Minecraft.getInstance());
        }

        @SubscribeEvent
        private static void onClientPlayConnectionJoin(ClientPlayerNetworkEvent.LoggingIn event) {
            instance.onJoinGame(Minecraft.getInstance().getConnection());
        }

        @SubscribeEvent
        private static void onWorldRender(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                if (((LevelRendererAccessor)event.getLevelRenderer()).getTransparencyChain() != null) {
                    try {
                        RenderSystem.getModelViewStack().pushMatrix();
                        RenderSystem.getModelViewStack().mul((Matrix4fc)event.getPoseStack().last().pose());
                        RenderSystem.applyModelViewMatrix();
                        event.getLevelRenderer().getTranslucentTarget().bindWrite(false);
                        instance.onPostRenderEntities(event.getPartialTick());
                    }
                    finally {
                        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
                        RenderSystem.getModelViewStack().popMatrix();
                    }
                }
            } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && ((LevelRendererAccessor)event.getLevelRenderer()).getTransparencyChain() == null) {
                try {
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.getModelViewStack().pushMatrix();
                    RenderSystem.getModelViewStack().mul((Matrix4fc)event.getPoseStack().last().pose());
                    RenderSystem.applyModelViewMatrix();
                    instance.onPostRenderEntities(event.getPartialTick());
                    RenderSystem.depthMask((boolean)false);
                }
                finally {
                    RenderSystem.getModelViewStack().popMatrix();
                    RenderSystem.applyModelViewMatrix();
                }
            }
        }
    }
}

