/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.neoforge;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistration;
import org.enginehub.worldeditcui.neoforge.NeoForgeModWorldEditCUI;
import org.enginehub.worldeditcui.neoforge.mixins.NetworkRegistryAccessor;

final class CUINetworking {
    static final String CHANNEL_LEGACY = "WECUI";
    static final ResourceLocation CHANNEL_WECUI = ResourceLocation.fromNamespaceAndPath((String)"worldedit", (String)"cui");
    private static Class<?> weCuiPacketClass;
    private static Method weCuiPacketTextMethod;
    private static Constructor<?> weCuiPacketConstructor;

    private CUINetworking() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void register(RegisterPayloadHandlersEvent event) {
        Map<ConnectionProtocol, Map<ResourceLocation, PayloadRegistration<?>>> registrations = NetworkRegistryAccessor.getPAYLOAD_REGISTRATIONS();
        if (registrations.get(ConnectionProtocol.PLAY).containsKey(CHANNEL_WECUI)) {
            PayloadRegistration<?> existingHandler = registrations.get(ConnectionProtocol.PLAY).get(CHANNEL_WECUI);
            PayloadRegistration newHandler = new PayloadRegistration(existingHandler.type(), existingHandler.codec(), (payload, context) -> {
                if (context.player() instanceof ServerPlayer) {
                    existingHandler.handler().handle(payload, context);
                    return;
                }
                try {
                    NeoForgeModWorldEditCUI.getInstance().onPluginMessage((String)weCuiPacketTextMethod.invoke((Object)payload, new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, existingHandler.protocols(), existingHandler.flow(), existingHandler.version(), existingHandler.optional());
            registrations.get(ConnectionProtocol.PLAY).put(CHANNEL_WECUI, newHandler);
        } else {
            event.registrar("1").optional().playBidirectional(ClientCuiPacket.TYPE, CustomPacketPayload.codec((packet, buffer) -> buffer.writeCharSequence((CharSequence)packet.text(), StandardCharsets.UTF_8), buffer -> new ClientCuiPacket(buffer.readCharSequence(buffer.readableBytes(), StandardCharsets.UTF_8).toString())), (payload, context) -> {
                if (context.player() instanceof ServerPlayer) {
                    return;
                }
                NeoForgeModWorldEditCUI.getInstance().onPluginMessage(payload.text());
            });
        }
    }

    public static void send(ClientPacketListener handler, String text) {
        if (weCuiPacketClass != null) {
            try {
                Object packet = weCuiPacketConstructor.newInstance(text);
                PacketDistributor.sendToServer((CustomPacketPayload)((CustomPacketPayload)packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new ClientCuiPacket(text), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        try {
            weCuiPacketClass = Class.forName("com.sk89q.worldedit.neoforge.net.handler.WECUIPacketHandler$CuiPacket");
            weCuiPacketTextMethod = weCuiPacketClass.getMethod("text", new Class[0]);
            weCuiPacketConstructor = weCuiPacketClass.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public record ClientCuiPacket(String text) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientCuiPacket> TYPE = new CustomPacketPayload.Type(CHANNEL_WECUI);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

