/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.gui.CUIConfigList;

public class CUIConfigPanel
extends Screen {
    private static final int BUTTON_DONE_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private final Screen parent;
    final CUIConfiguration configuration;
    private AbstractWidget done;
    private CUIConfigList configList;
    private final Component screenTitle;

    public CUIConfigPanel(Screen parent, CUIConfiguration configuration) {
        super((Component)Component.literal((String)"WorldEditCUI"));
        this.parent = parent;
        this.configuration = configuration;
        this.screenTitle = Component.translatable((String)"worldeditcui.options.title");
    }

    protected void init() {
        super.init();
        this.done = (AbstractWidget)this.addWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.configuration.configChanged();
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds((this.width - 200) / 2, this.height - 27, 200, 20).build());
        this.configList = new CUIConfigList(this, this.minecraft);
        this.addWidget((GuiEventListener)this.configList);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float delta) {
        super.render(gfx, mouseX, mouseY, delta);
        this.configList.render(gfx, mouseX, mouseY, delta);
        gfx.drawCenteredString(this.font, this.screenTitle, this.width / 2, 8, 0xFFFFFF);
        this.done.render(gfx, mouseX, mouseY, delta);
    }
}

