/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.gui.CUIConfigPanel;
import org.slf4j.Logger;

public class CUIConfigList
extends ContainerObjectSelectionList<ConfigEntry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private static final Style invalidFormat = Style.EMPTY.withColor(ChatFormatting.DARK_RED).withUnderlined(Boolean.valueOf(true));
    private final CUIConfiguration configuration;
    int maxNameWidth = 0;

    public CUIConfigList(CUIConfigPanel panel, Minecraft minecraft) {
        super(minecraft, panel.width + 45, panel.height - 60, 25, 25);
        this.configuration = panel.configuration;
        for (String key : this.configuration.getConfigArray().keySet()) {
            Object value = this.configuration.getConfigArray().get(key);
            this.maxNameWidth = Math.max(this.maxNameWidth, minecraft.font.width((FormattedText)this.configuration.getDescription(key)));
            if (value instanceof Boolean) {
                this.addEntry((AbstractSelectionList.Entry)new OnOffEntry(key));
                continue;
            }
            if (value instanceof Colour) {
                this.addEntry((AbstractSelectionList.Entry)new ColorConfigEntry(key));
                continue;
            }
            LOGGER.warn("WorldEditCUI has option {} with unknown data type {}", (Object)key, (Object)(value == null ? "NULL" : value.getClass().getName()));
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 15;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    public class OnOffEntry
    extends ConfigEntry {
        private final CycleButton<Boolean> toggleBotton;

        public OnOffEntry(String tag) {
            super(tag);
            Boolean value = (Boolean)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.toggleBotton = CycleButton.onOffBuilder((boolean)value).displayOnlyValue().create(0, 0, 70, 20, CUIConfigList.this.configuration.getDescription(tag), (press, boolean_) -> CUIConfigList.this.configuration.changeValue(tag, boolean_));
        }

        @Override
        public void render(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.render(gfx, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTick);
            this.toggleBotton.setX(left + 105);
            this.toggleBotton.setY(top);
            this.toggleBotton.render(gfx, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.resetButton, this.toggleBotton);
        }

        @Override
        protected void updateFromConfig() {
            this.toggleBotton.setValue((Object)((Boolean)CUIConfigList.this.configuration.getConfigArray().get(this.tag)));
        }
    }

    public class ColorConfigEntry
    extends ConfigEntry {
        private final EditBox textField;

        public ColorConfigEntry(String tag) {
            super(tag);
            Colour cValue = (Colour)CUIConfigList.this.configuration.getConfigArray().get(tag);
            this.textField = new EditBox(((CUIConfigList)CUIConfigList.this).minecraft.font, 0, 0, 70, 20, (Component)Component.literal((String)cValue.hexString()));
            this.textField.setMaxLength(9);
            this.textField.setValue(cValue.hexString());
            this.textField.setResponder(updated -> {
                Colour tested = Colour.parseRgbaOrNull(updated);
                if (tested != null) {
                    CUIConfigList.this.configuration.changeValue(tag, tested);
                }
            });
            this.textField.setFormatter((string, integer) -> {
                String colorSource = this.textField.getValue();
                if (colorSource.length() != 9) {
                    return FormattedCharSequence.forward((String)string, (Style)invalidFormat);
                }
                return TextColor.parseColor((String)colorSource.substring(0, 7)).map(color -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY.withColor(color))).result().orElseGet(() -> FormattedCharSequence.forward((String)string, (Style)invalidFormat));
            });
            this.textField.setFilter(value -> {
                if (value.length() >= 1 && value.charAt(0) != '#') {
                    return false;
                }
                for (int i = 1; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                    return false;
                }
                return true;
            });
        }

        @Override
        public void render(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            super.render(gfx, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTick);
            this.textField.setX(left + 105);
            this.textField.setY(top);
            this.textField.render(gfx, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.resetButton, (Object)this.textField);
        }

        @Override
        protected void updateFromConfig() {
            this.textField.setValue(((Colour)CUIConfigList.this.configuration.getConfigArray().get(this.tag)).hexString());
        }
    }

    public abstract class ConfigEntry
    extends ContainerObjectSelectionList.Entry<ConfigEntry> {
        protected final String tag;
        protected final Button resetButton;
        protected final StringWidget textField;

        public ConfigEntry(String tag) {
            this.tag = tag;
            this.resetButton = Button.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                CUIConfigList.this.configuration.changeValue(tag, CUIConfigList.this.configuration.getDefaultValue(tag));
                this.updateFromConfig();
            }).bounds(0, 0, 50, 20).build();
            this.textField = new StringWidget(CUIConfigList.this.configuration.getDescription(tag), ((CUIConfigList)CUIConfigList.this).minecraft.font);
            this.textField.alignLeft();
            Component tooltip = CUIConfigList.this.configuration.getTooltip(tag);
            if (tooltip != null) {
                this.textField.setTooltip(Tooltip.create((Component)tooltip));
            }
        }

        public void render(GuiGraphics gfx, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            int textLeft = left + 90 - CUIConfigList.this.maxNameWidth;
            this.textField.setX(textLeft);
            this.textField.setY(top);
            this.textField.render(gfx, mouseX, mouseY, partialTick);
            this.resetButton.setX(left + 190);
            this.resetButton.setY(top);
            this.resetButton.render(gfx, mouseX, mouseY, partialTick);
        }

        protected abstract void updateFromConfig();
    }
}

