/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor;

import java.util.Stack;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.EcmaScriptTokenStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.Token;

public class Lexer {
    private final EcmaScriptTokenStream stream;
    private final LookBehind lastThree;
    private final Stack<Brace> braceStack;
    private final Stack<Paren> parenStack;

    public Lexer(String js) {
        this.stream = new EcmaScriptTokenStream(js, 0, false);
        this.lastThree = new LookBehind();
        this.braceStack = new Stack();
        this.parenStack = new Stack();
    }

    public ParsedToken getNextToken() throws ParsingException {
        Token token = this.stream.nextToken();
        if ((token == Token.DIV || token == Token.ASSIGN_DIV) && this.isRegexStart()) {
            this.stream.readRegExp(token);
            token = Token.REGEXP;
        }
        ParsedToken parsedToken = new ParsedToken(token, this.stream.tokenBeg, this.stream.tokenEnd);
        this.keepBooks(parsedToken);
        return parsedToken;
    }

    public boolean isBalanced() {
        return this.braceStack.isEmpty() && this.parenStack.isEmpty();
    }

    void keepBooks(ParsedToken parsedToken) throws ParsingException {
        if (parsedToken.token.isPunct) {
            switch (parsedToken.token) {
                case LP: {
                    this.handleOpenParenBooks();
                    return;
                }
                case LC: {
                    this.handleOpenBraceBooks();
                    return;
                }
                case RP: {
                    this.handleCloseParenBooks(parsedToken.start);
                    return;
                }
                case RC: {
                    this.handleCloseBraceBooks(parsedToken.start);
                    return;
                }
            }
        }
        if (parsedToken.token != Token.COMMENT) {
            this.lastThree.push(new MetaToken(parsedToken.token, this.stream.lineno));
        }
    }

    void handleOpenParenBooks() {
        boolean funcExpr = false;
        if (this.lastThree.oneIs(Token.FUNCTION)) {
            funcExpr = this.lastThree.two() != null && this.checkForExpression(this.lastThree.two().token);
        } else if (this.lastThree.twoIs(Token.FUNCTION)) {
            funcExpr = this.lastThree.three() != null && this.checkForExpression(this.lastThree.three().token);
        }
        boolean conditional = this.lastThree.one() != null && this.lastThree.one().token.isConditional();
        Paren paren = new Paren(funcExpr, conditional);
        this.parenStack.push(paren);
        this.lastThree.push(new ParenMetaToken(Token.LP, this.stream.lineno, paren));
    }

    void handleOpenBraceBooks() {
        boolean isBlock = true;
        if (this.lastThree.one() != null) {
            switch (this.lastThree.one().token) {
                case LP: 
                case LC: 
                case CASE: {
                    isBlock = false;
                    break;
                }
                case COLON: {
                    isBlock = !this.braceStack.isEmpty() && ((Brace)this.braceStack.lastElement()).isBlock;
                    break;
                }
                case RETURN: 
                case YIELD: 
                case YIELD_STAR: {
                    isBlock = this.lastThree.two() != null && this.lastThree.two().lineno != this.stream.lineno;
                    break;
                }
                default: {
                    isBlock = !this.lastThree.one().token.isOp;
                }
            }
        }
        Paren paren = null;
        if (this.lastThree.one() instanceof ParenMetaToken && this.lastThree.one().token == Token.RP) {
            paren = ((ParenMetaToken)this.lastThree.one()).paren;
        }
        Brace brace = new Brace(isBlock, paren);
        this.braceStack.push(brace);
        this.lastThree.push(new BraceMetaToken(Token.LC, this.stream.lineno, brace));
    }

    void handleCloseParenBooks(int start) throws ParsingException {
        if (this.parenStack.isEmpty()) {
            throw new ParsingException("unmatched closing paren at " + start);
        }
        this.lastThree.push(new ParenMetaToken(Token.RP, this.stream.lineno, this.parenStack.pop()));
    }

    void handleCloseBraceBooks(int start) throws ParsingException {
        if (this.braceStack.isEmpty()) {
            throw new ParsingException("unmatched closing brace at " + start);
        }
        this.lastThree.push(new BraceMetaToken(Token.RC, this.stream.lineno, this.braceStack.pop()));
    }

    boolean checkForExpression(Token token) {
        return token.isOp || token == Token.RETURN || token == Token.CASE;
    }

    boolean isRegexStart() {
        if (this.lastThree.one() != null) {
            Token t = this.lastThree.one().token;
            if (t.isKeyw) {
                return t != Token.THIS;
            }
            if (t == Token.RP && this.lastThree.one() instanceof ParenMetaToken) {
                return ((ParenMetaToken)this.lastThree.one()).paren.conditional;
            }
            if (t == Token.RC && this.lastThree.one() instanceof BraceMetaToken) {
                BraceMetaToken mt = (BraceMetaToken)this.lastThree.one();
                if (mt.brace.isBlock) {
                    if (mt.brace.paren != null) {
                        return !mt.brace.paren.funcExpr;
                    }
                    return true;
                }
                return false;
            }
            if (t.isPunct) {
                return t != Token.RB;
            }
            return false;
        }
        return true;
    }

    public static class ParsedToken {
        public final Token token;
        public final int start;
        public final int end;

        ParsedToken(Token token, int start, int end) {
            this.token = token;
            this.start = start;
            this.end = end;
        }
    }

    private static class LookBehind {
        private final MetaToken[] list = new MetaToken[3];

        LookBehind() {
        }

        void push(MetaToken t) {
            MetaToken toShift = t;
            for (int i = 0; i < 3; ++i) {
                MetaToken tmp = this.list[i];
                this.list[i] = toShift;
                toShift = tmp;
            }
        }

        MetaToken one() {
            return this.list[0];
        }

        MetaToken two() {
            return this.list[1];
        }

        MetaToken three() {
            return this.list[2];
        }

        boolean oneIs(Token token) {
            return this.list[0] != null && this.list[0].token == token;
        }

        boolean twoIs(Token token) {
            return this.list[1] != null && this.list[1].token == token;
        }

        boolean threeIs(Token token) {
            return this.list[2] != null && this.list[2].token == token;
        }
    }

    private static class ParenMetaToken
    extends MetaToken {
        public final Paren paren;

        ParenMetaToken(Token token, int lineno, Paren paren) {
            super(token, lineno);
            this.paren = paren;
        }
    }

    private static class BraceMetaToken
    extends MetaToken {
        public final Brace brace;

        BraceMetaToken(Token token, int lineno, Brace brace) {
            super(token, lineno);
            this.brace = brace;
        }
    }

    private static class MetaToken {
        public final Token token;
        public final int lineno;

        MetaToken(Token token, int lineno) {
            this.token = token;
            this.lineno = lineno;
        }
    }

    private static class Brace {
        public final boolean isBlock;
        public final Paren paren;

        Brace(boolean isBlock, Paren paren) {
            this.isBlock = isBlock;
            this.paren = paren;
        }
    }

    private static class Paren {
        public final boolean funcExpr;
        public final boolean conditional;

        Paren(boolean funcExpr, boolean conditional) {
            this.funcExpr = funcExpr;
            this.conditional = conditional;
        }
    }
}

