/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor;

import org.watermedia.shaded.mozilla.javascript.Kit;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.Token;

class EcmaScriptTokenStream {
    private static final int EOF_CHAR = -1;
    private static final int REPORT_NUMBER_FORMAT_ERROR = -2;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char NUMERIC_SEPARATOR = '_';
    private boolean dirtyLine;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    private final int[] ungetBuffer = new int[3];
    private int ungetCursor;
    private int lineEndChar = -1;
    int lineno;
    private final String sourceString;
    private int sourceCursor;
    private int cursor;
    int tokenBeg;
    int tokenEnd;
    private final boolean strictMode;

    EcmaScriptTokenStream(String sourceString, int lineno, boolean strictMode) {
        this.sourceString = sourceString;
        this.sourceCursor = 0;
        this.cursor = 0;
        this.lineno = lineno;
        this.strictMode = strictMode;
    }

    private Token stringToKeyword(String name) {
        return EcmaScriptTokenStream.stringToKeywordForES(name, this.strictMode);
    }

    private static Token stringToKeywordForES(String name, boolean isStrict) {
        switch (name) {
            case "break": {
                return Token.BREAK;
            }
            case "case": {
                return Token.CASE;
            }
            case "catch": {
                return Token.CATCH;
            }
            case "const": {
                return Token.CONST;
            }
            case "continue": {
                return Token.CONTINUE;
            }
            case "debugger": {
                return Token.DEBUGGER;
            }
            case "default": {
                return Token.DEFAULT;
            }
            case "delete": {
                return Token.DELPROP;
            }
            case "do": {
                return Token.DO;
            }
            case "else": {
                return Token.ELSE;
            }
            case "export": {
                return Token.EXPORT;
            }
            case "finally": {
                return Token.FINALLY;
            }
            case "for": {
                return Token.FOR;
            }
            case "function": {
                return Token.FUNCTION;
            }
            case "if": {
                return Token.IF;
            }
            case "import": {
                return Token.IMPORT;
            }
            case "in": {
                return Token.IN;
            }
            case "instanceof": {
                return Token.INSTANCEOF;
            }
            case "new": {
                return Token.NEW;
            }
            case "return": {
                return Token.RETURN;
            }
            case "switch": {
                return Token.SWITCH;
            }
            case "this": {
                return Token.THIS;
            }
            case "throw": {
                return Token.THROW;
            }
            case "try": {
                return Token.TRY;
            }
            case "typeof": {
                return Token.TYPEOF;
            }
            case "var": {
                return Token.VAR;
            }
            case "void": {
                return Token.VOID;
            }
            case "while": {
                return Token.WHILE;
            }
            case "with": {
                return Token.WITH;
            }
            case "yield": {
                return Token.YIELD;
            }
            case "false": {
                return Token.FALSE;
            }
            case "null": {
                return Token.NULL;
            }
            case "true": {
                return Token.TRUE;
            }
            case "let": {
                return Token.LET;
            }
            case "class": 
            case "extends": 
            case "super": 
            case "await": 
            case "enum": {
                return Token.RESERVED;
            }
            case "implements": 
            case "interface": 
            case "package": 
            case "private": 
            case "protected": 
            case "public": 
            case "static": {
                if (!isStrict) break;
                return Token.RESERVED;
            }
        }
        return Token.EOF;
    }

    final Token getToken() throws ParsingException {
        boolean identifierStart;
        int c;
        do {
            if ((c = this.getChar()) == -1) {
                this.tokenBeg = this.cursor - 1;
                this.tokenEnd = this.cursor;
                return Token.EOF;
            }
            if (c != 10) continue;
            this.dirtyLine = false;
            this.tokenBeg = this.cursor - 1;
            this.tokenEnd = this.cursor;
            return Token.EOL;
        } while (EcmaScriptTokenStream.isJSSpace(c));
        if (c != 45) {
            this.dirtyLine = true;
        }
        this.tokenBeg = this.cursor - 1;
        this.tokenEnd = this.cursor;
        boolean isUnicodeEscapeStart = false;
        if (c == 92) {
            c = this.getChar();
            if (c == 117) {
                identifierStart = true;
                isUnicodeEscapeStart = true;
                this.stringBufferTop = 0;
            } else {
                identifierStart = false;
                this.ungetChar(c);
                c = 92;
            }
        } else {
            identifierStart = Character.isJavaIdentifierStart((char)c);
            if (identifierStart) {
                this.stringBufferTop = 0;
                this.addToString(c);
            }
        }
        if (identifierStart) {
            Token result;
            boolean containsEscape = isUnicodeEscapeStart;
            while (true) {
                if (isUnicodeEscapeStart) {
                    int escapeVal = 0;
                    for (int i = 0; i != 4 && (escapeVal = Kit.xDigitToInt(c = this.getChar(), escapeVal)) >= 0; ++i) {
                    }
                    if (escapeVal < 0) {
                        throw new ParsingException("invalid unicode escape");
                    }
                    this.addToString(escapeVal);
                    isUnicodeEscapeStart = false;
                    continue;
                }
                c = this.getChar();
                if (c == 92) {
                    c = this.getChar();
                    if (c == 117) {
                        isUnicodeEscapeStart = true;
                        containsEscape = true;
                        continue;
                    }
                    throw new ParsingException(String.format("illegal character: '%c'", c));
                }
                if (c == -1 || c == 65279 || !Character.isJavaIdentifierPart((char)c)) break;
                this.addToString(c);
            }
            this.ungetChar(c);
            String str = this.getStringFromBuffer();
            if (!containsEscape && (result = this.stringToKeyword(str)) != Token.EOF) {
                return result;
            }
            return Token.NAME;
        }
        if (EcmaScriptTokenStream.isDigit(c) || c == 46 && EcmaScriptTokenStream.isDigit(this.peekChar())) {
            this.stringBufferTop = 0;
            int base = 10;
            boolean isOldOctal = false;
            if (c == 48) {
                c = this.getChar();
                if (c == 120 || c == 88) {
                    base = 16;
                    c = this.getChar();
                } else if (c == 111 || c == 79) {
                    base = 8;
                    c = this.getChar();
                } else if (c == 98 || c == 66) {
                    base = 2;
                    c = this.getChar();
                } else if (EcmaScriptTokenStream.isDigit(c)) {
                    base = 8;
                    isOldOctal = true;
                } else {
                    this.addToString(48);
                }
            }
            int emptyDetector = this.stringBufferTop;
            if (base == 10 || base == 16 || base == 8 && !isOldOctal || base == 2) {
                if ((c = this.readDigits(base, c)) == -2) {
                    throw new ParsingException("number format error");
                }
            } else {
                while (EcmaScriptTokenStream.isDigit(c)) {
                    if (c >= 56) {
                        base = 10;
                        if ((c = this.readDigits(base, c)) != -2) break;
                        throw new ParsingException("number format error");
                    }
                    this.addToString(c);
                    c = this.getChar();
                }
            }
            if (this.stringBufferTop == emptyDetector && base != 10) {
                throw new ParsingException("number format error");
            }
            if (c == 110) {
                c = this.getChar();
            } else if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                if (c == 46) {
                    this.addToString(c);
                    c = this.getChar();
                    c = this.readDigits(base, c);
                    if (c == -2) {
                        throw new ParsingException("number format error");
                    }
                }
                if (c == 101 || c == 69) {
                    this.addToString(c);
                    c = this.getChar();
                    if (c == 43 || c == 45) {
                        this.addToString(c);
                        c = this.getChar();
                    }
                    if (!EcmaScriptTokenStream.isDigit(c)) {
                        throw new ParsingException("missing exponent");
                    }
                    if ((c = this.readDigits(base, c)) == -2) {
                        throw new ParsingException("number format error");
                    }
                }
            }
            this.ungetChar(c);
            this.tokenEnd = this.cursor;
            return Token.NUMBER;
        }
        if (c == 34 || c == 39 || c == 96) {
            int quoteChar = c;
            this.stringBufferTop = 0;
            c = this.getCharIgnoreLineEnd(false);
            block45: while (c != quoteChar) {
                boolean unterminated = false;
                if (c == -1) {
                    unterminated = true;
                } else if (c == 10) {
                    switch (this.lineEndChar) {
                        case 10: 
                        case 13: {
                            unterminated = true;
                            break;
                        }
                        case 8232: 
                        case 8233: {
                            c = this.lineEndChar;
                            break;
                        }
                    }
                }
                if (unterminated) {
                    throw new ParsingException("unterminated string literal");
                }
                if (c == 92) {
                    c = this.getChar();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: {
                            int escapeStart = this.stringBufferTop;
                            this.addToString(117);
                            int escapeVal = 0;
                            for (int i = 0; i != 4; ++i) {
                                c = this.getChar();
                                escapeVal = Kit.xDigitToInt(c, escapeVal);
                                if (escapeVal < 0) continue block45;
                                this.addToString(c);
                            }
                            this.stringBufferTop = escapeStart;
                            c = escapeVal;
                            break;
                        }
                        case 120: {
                            c = this.getChar();
                            int escapeVal = Kit.xDigitToInt(c, 0);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                continue block45;
                            }
                            int c1 = c;
                            c = this.getChar();
                            escapeVal = Kit.xDigitToInt(c, escapeVal);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                this.addToString(c1);
                                continue block45;
                            }
                            c = escapeVal;
                            break;
                        }
                        case 10: {
                            c = this.getChar();
                            continue block45;
                        }
                        default: {
                            if (48 > c || c >= 56) break;
                            int val = c - 48;
                            c = this.getChar();
                            if (48 <= c && c < 56) {
                                val = 8 * val + c - 48;
                                c = this.getChar();
                                if (48 <= c && c < 56 && val <= 31) {
                                    val = 8 * val + c - 48;
                                    c = this.getChar();
                                }
                            }
                            this.ungetChar(c);
                            c = val;
                        }
                    }
                }
                this.addToString(c);
                c = this.getChar(false);
            }
            this.tokenEnd = this.cursor;
            return quoteChar == 96 ? Token.TEMPLATE_LITERAL : Token.STRING;
        }
        switch (c) {
            case 59: {
                return Token.SEMI;
            }
            case 91: {
                return Token.LB;
            }
            case 93: {
                return Token.RB;
            }
            case 123: {
                return Token.LC;
            }
            case 125: {
                return Token.RC;
            }
            case 40: {
                return Token.LP;
            }
            case 41: {
                return Token.RP;
            }
            case 44: {
                return Token.COMMA;
            }
            case 63: {
                return Token.HOOK;
            }
            case 58: {
                return Token.COLON;
            }
            case 46: {
                return Token.DOT;
            }
            case 124: {
                if (this.matchChar(124)) {
                    return Token.OR;
                }
                if (this.matchChar(61)) {
                    return Token.ASSIGN_BITOR;
                }
                return Token.BITOR;
            }
            case 94: {
                if (this.matchChar(61)) {
                    return Token.ASSIGN_BITXOR;
                }
                return Token.BITXOR;
            }
            case 38: {
                if (this.matchChar(38)) {
                    return Token.AND;
                }
                if (this.matchChar(61)) {
                    return Token.ASSIGN_BITAND;
                }
                return Token.BITAND;
            }
            case 61: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return Token.SHEQ;
                    }
                    return Token.EQ;
                }
                if (this.matchChar(62)) {
                    return Token.ARROW;
                }
                return Token.ASSIGN;
            }
            case 33: {
                if (this.matchChar(61)) {
                    if (this.matchChar(61)) {
                        return Token.SHNE;
                    }
                    return Token.NE;
                }
                return Token.NOT;
            }
            case 60: {
                if (this.matchChar(33)) {
                    if (this.matchChar(45)) {
                        if (this.matchChar(45)) {
                            this.tokenBeg = this.cursor - 4;
                            this.skipLine();
                            return Token.COMMENT;
                        }
                        this.ungetCharIgnoreLineEnd(45);
                    }
                    this.ungetCharIgnoreLineEnd(33);
                }
                if (this.matchChar(60)) {
                    if (this.matchChar(61)) {
                        return Token.ASSIGN_LSH;
                    }
                    return Token.LSH;
                }
                if (this.matchChar(61)) {
                    return Token.LE;
                }
                return Token.LT;
            }
            case 62: {
                if (this.matchChar(62)) {
                    if (this.matchChar(62)) {
                        if (this.matchChar(61)) {
                            return Token.ASSIGN_URSH;
                        }
                        return Token.URSH;
                    }
                    if (this.matchChar(61)) {
                        return Token.ASSIGN_RSH;
                    }
                    return Token.RSH;
                }
                if (this.matchChar(61)) {
                    return Token.GE;
                }
                return Token.GT;
            }
            case 42: {
                if (this.matchChar(42)) {
                    if (this.matchChar(61)) {
                        return Token.ASSIGN_EXP;
                    }
                    return Token.EXP;
                }
                if (this.matchChar(61)) {
                    return Token.ASSIGN_MUL;
                }
                return Token.MUL;
            }
            case 47: {
                if (this.matchChar(47)) {
                    this.tokenBeg = this.cursor - 2;
                    this.skipLine();
                    return Token.COMMENT;
                }
                if (this.matchChar(42)) {
                    boolean lookForSlash = false;
                    this.tokenBeg = this.cursor - 2;
                    if (this.matchChar(42)) {
                        lookForSlash = true;
                    }
                    while (true) {
                        if ((c = this.getChar()) == -1) {
                            this.tokenEnd = this.cursor - 1;
                            throw new ParsingException("unterminated comment");
                        }
                        if (c == 42) {
                            lookForSlash = true;
                            continue;
                        }
                        if (c == 47) {
                            if (!lookForSlash) continue;
                            this.tokenEnd = this.cursor;
                            return Token.COMMENT;
                        }
                        lookForSlash = false;
                        this.tokenEnd = this.cursor;
                    }
                }
                if (this.matchChar(61)) {
                    return Token.ASSIGN_DIV;
                }
                return Token.DIV;
            }
            case 37: {
                if (this.matchChar(61)) {
                    return Token.ASSIGN_MOD;
                }
                return Token.MOD;
            }
            case 126: {
                return Token.BITNOT;
            }
            case 43: {
                if (this.matchChar(61)) {
                    return Token.ASSIGN_ADD;
                }
                if (this.matchChar(43)) {
                    return Token.INC;
                }
                return Token.ADD;
            }
            case 45: {
                Token t = Token.SUB;
                if (this.matchChar(61)) {
                    t = Token.ASSIGN_SUB;
                } else if (this.matchChar(45)) {
                    if (!this.dirtyLine && this.matchChar(62)) {
                        this.skipLine();
                        return Token.COMMENT;
                    }
                    t = Token.DEC;
                }
                this.dirtyLine = true;
                return t;
            }
        }
        throw new ParsingException(String.format("illegal character: '%c'", c));
    }

    private int readDigits(int base, int firstC) {
        if (EcmaScriptTokenStream.isDigit(base, firstC)) {
            int c;
            block6: {
                this.addToString(firstC);
                c = this.getChar();
                if (c == -1) {
                    return -1;
                }
                while (true) {
                    if (c == 95) {
                        c = this.getChar();
                        if (c == 10 || c == -1) {
                            return -2;
                        }
                        if (!EcmaScriptTokenStream.isDigit(base, c)) {
                            this.ungetChar(c);
                            return 95;
                        }
                        this.addToString(95);
                        continue;
                    }
                    if (!EcmaScriptTokenStream.isDigit(base, c)) break block6;
                    this.addToString(c);
                    c = this.getChar();
                    if (c == -1) break;
                }
                return -1;
            }
            return c;
        }
        return firstC;
    }

    private static boolean isAlpha(int c) {
        if (c <= 90) {
            return 65 <= c;
        }
        return 97 <= c && c <= 122;
    }

    private static boolean isDigit(int base, int c) {
        return base == 10 && EcmaScriptTokenStream.isDigit(c) || base == 16 && EcmaScriptTokenStream.isHexDigit(c) || base == 8 && EcmaScriptTokenStream.isOctalDigit(c) || base == 2 && EcmaScriptTokenStream.isDualDigit(c);
    }

    private static boolean isDualDigit(int c) {
        return 48 == c || c == 49;
    }

    private static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isHexDigit(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || c == 65279 || Character.getType((char)c) == 12;
    }

    private static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType((char)c) == 16;
    }

    void readRegExp(Token startToken) throws ParsingException {
        int c;
        int start = this.tokenBeg;
        this.stringBufferTop = 0;
        if (startToken == Token.ASSIGN_DIV) {
            this.addToString(61);
        } else {
            if (startToken != Token.DIV) {
                Kit.codeBug();
            }
            if (this.peekChar() == 42) {
                this.tokenEnd = this.cursor - 1;
                throw new ParsingException("msg.unterminated.re.lit");
            }
        }
        boolean inCharSet = false;
        while ((c = this.getChar()) != 47 || inCharSet) {
            if (c == 10 || c == -1) {
                throw new ParsingException("msg.unterminated.re.lit");
            }
            if (c == 92) {
                this.addToString(c);
                c = this.getChar();
                if (c == 10 || c == -1) {
                    throw new ParsingException("msg.unterminated.re.lit");
                }
            } else if (c == 91) {
                inCharSet = true;
            } else if (c == 93) {
                inCharSet = false;
            }
            this.addToString(c);
        }
        while ("gimysu".indexOf(c = this.getCharIgnoreLineEnd()) != -1) {
            this.addToString(c);
        }
        if (EcmaScriptTokenStream.isAlpha(c)) {
            throw new ParsingException("msg.invalid.re.flag");
        }
        this.ungetCharIgnoreLineEnd(c);
        this.tokenEnd = start + this.stringBufferTop + 2;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        int n = this.stringBufferTop;
        if (n == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, n);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[n] = (char)c;
        this.stringBufferTop = n + 1;
    }

    private void ungetChar(int c) {
        if (this.ungetCursor != 0 && this.ungetBuffer[this.ungetCursor - 1] == 10) {
            Kit.codeBug();
        }
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private boolean matchChar(int test) {
        int c = this.getCharIgnoreLineEnd();
        if (c == test) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(c);
        return false;
    }

    private int peekChar() {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    private int getChar() {
        return this.getChar(true, false);
    }

    private int getChar(boolean skipFormattingChars) {
        return this.getChar(skipFormattingChars, false);
    }

    private int getChar(boolean skipFormattingChars, boolean ignoreLineEnd) {
        int c;
        block9: {
            if (this.ungetCursor != 0) {
                ++this.cursor;
                return this.ungetBuffer[--this.ungetCursor];
            }
            while (true) {
                if (this.sourceCursor == this.sourceString.length()) {
                    return -1;
                }
                ++this.cursor;
                c = this.sourceString.charAt(this.sourceCursor++);
                if (!ignoreLineEnd && this.lineEndChar >= 0) {
                    if (this.lineEndChar == 13 && c == 10) {
                        this.lineEndChar = 10;
                        continue;
                    }
                    this.lineEndChar = -1;
                    ++this.lineno;
                }
                if (c <= 127) {
                    if (c == 10 || c == 13) {
                        this.lineEndChar = c;
                        c = 10;
                    }
                    break block9;
                }
                if (c == 65279) {
                    return c;
                }
                if (!skipFormattingChars || !EcmaScriptTokenStream.isJSFormatChar(c)) break;
            }
            if (ScriptRuntime.isJSLineTerminator(c)) {
                this.lineEndChar = c;
                c = 10;
            }
        }
        return c;
    }

    private int getCharIgnoreLineEnd() {
        return this.getChar(true, true);
    }

    private int getCharIgnoreLineEnd(boolean skipFormattingChars) {
        return this.getChar(skipFormattingChars, true);
    }

    private void ungetCharIgnoreLineEnd(int c) {
        this.ungetBuffer[this.ungetCursor++] = c;
        --this.cursor;
    }

    private void skipLine() {
        int c;
        while ((c = this.getChar()) != -1 && c != 10) {
        }
        this.ungetChar(c);
        this.tokenEnd = this.cursor;
    }

    public Token nextToken() throws ParsingException {
        Token tt = this.getToken();
        while (tt == Token.EOL || tt == Token.COMMENT) {
            tt = this.getToken();
        }
        return tt;
    }
}

