/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class Parser {
    private Parser() {
    }

    public static String matchGroup1(String pattern, String input) throws RegexException {
        return Parser.matchGroup(pattern, input, 1);
    }

    public static String matchGroup1(Pattern pattern, String input) throws RegexException {
        return Parser.matchGroup(pattern, input, 1);
    }

    public static String matchGroup(String pattern, String input, int group) throws RegexException {
        return Parser.matchGroup(Pattern.compile(pattern), input, group);
    }

    public static String matchGroup(@Nonnull Pattern pat, String input, int group) throws RegexException {
        Matcher matcher = pat.matcher(input);
        boolean foundMatch = matcher.find();
        if (foundMatch) {
            return matcher.group(group);
        }
        if (input.length() > 1024) {
            throw new RegexException("Failed to find pattern \"" + pat.pattern() + "\"");
        }
        throw new RegexException("Failed to find pattern \"" + pat.pattern() + "\" inside of \"" + input + "\"");
    }

    public static String matchGroup1MultiplePatterns(Pattern[] patterns, String input) throws RegexException {
        return Parser.matchMultiplePatterns(patterns, input).group(1);
    }

    public static Matcher matchMultiplePatterns(Pattern[] patterns, String input) throws RegexException {
        RegexException exception = null;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                return matcher;
            }
            if (exception != null) continue;
            exception = new RegexException("Failed to find pattern \"" + pattern.pattern() + "\"" + (String)(input.length() <= 1000 ? "inside of \"" + input + "\"" : ""));
        }
        throw exception != null ? exception : new RegexException("Empty patterns array passed to matchMultiplePatterns");
    }

    public static boolean isMatch(String pattern, String input) {
        Pattern pat = Pattern.compile(pattern);
        Matcher mat = pat.matcher(input);
        return mat.find();
    }

    public static boolean isMatch(@Nonnull Pattern pattern, String input) {
        Matcher mat = pattern.matcher(input);
        return mat.find();
    }

    @Nonnull
    public static Map<String, String> compatParseMap(@Nonnull String input) {
        return Arrays.stream(input.split("&")).map(arg -> arg.split("=")).filter(splitArg -> ((String[])splitArg).length > 1).collect(Collectors.toMap(splitArg -> splitArg[0], splitArg -> Utils.decodeUrlUtf8(splitArg[1]), (existing, replacement) -> replacement));
    }

    public static class RegexException
    extends ParsingException {
        public RegexException(String message) {
            super(message);
        }
    }
}

