/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;

public final class VideoStream
extends Stream {
    public static final String RESOLUTION_UNKNOWN = "";
    @Deprecated
    public final String resolution;
    @Deprecated
    public final boolean isVideoOnly;
    private int itag = -1;
    private int bitrate;
    private int initStart;
    private int initEnd;
    private int indexStart;
    private int indexEnd;
    private int width;
    private int height;
    private int fps;
    private String quality;
    private String codec;
    @Nullable
    private ItagItem itagItem;

    private VideoStream(@Nonnull String id2, @Nonnull String content, boolean isUrl, @Nullable MediaFormat format, @Nonnull DeliveryMethod deliveryMethod, @Nonnull String resolution, boolean isVideoOnly, @Nullable String manifestUrl, @Nullable ItagItem itagItem) {
        super(id2, content, isUrl, format, deliveryMethod, manifestUrl);
        if (itagItem != null) {
            this.itagItem = itagItem;
            this.itag = itagItem.id;
            this.bitrate = itagItem.getBitrate();
            this.initStart = itagItem.getInitStart();
            this.initEnd = itagItem.getInitEnd();
            this.indexStart = itagItem.getIndexStart();
            this.indexEnd = itagItem.getIndexEnd();
            this.codec = itagItem.getCodec();
            this.height = itagItem.getHeight();
            this.width = itagItem.getWidth();
            this.quality = itagItem.getQuality();
            this.fps = itagItem.getFps();
        }
        this.resolution = resolution;
        this.isVideoOnly = isVideoOnly;
    }

    @Override
    public boolean equalStats(Stream cmp) {
        return super.equalStats(cmp) && cmp instanceof VideoStream && this.resolution.equals(((VideoStream)cmp).resolution) && this.isVideoOnly == ((VideoStream)cmp).isVideoOnly;
    }

    @Nonnull
    public String getResolution() {
        return this.resolution;
    }

    public boolean isVideoOnly() {
        return this.isVideoOnly;
    }

    public int getItag() {
        return this.itag;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getInitStart() {
        return this.initStart;
    }

    public int getInitEnd() {
        return this.initEnd;
    }

    public int getIndexStart() {
        return this.indexStart;
    }

    public int getIndexEnd() {
        return this.indexEnd;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getCodec() {
        return this.codec;
    }

    @Override
    @Nullable
    public ItagItem getItagItem() {
        return this.itagItem;
    }

    public static final class Builder {
        private String id;
        private String content;
        private boolean isUrl;
        private DeliveryMethod deliveryMethod = DeliveryMethod.PROGRESSIVE_HTTP;
        @Nullable
        private MediaFormat mediaFormat;
        @Nullable
        private String manifestUrl;
        private Boolean isVideoOnly;
        private String resolution;
        @Nullable
        private ItagItem itagItem;

        public Builder setId(@Nonnull String id2) {
            this.id = id2;
            return this;
        }

        public Builder setContent(@Nonnull String content, boolean isUrl) {
            this.content = content;
            this.isUrl = isUrl;
            return this;
        }

        public Builder setMediaFormat(@Nullable MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        public Builder setDeliveryMethod(@Nonnull DeliveryMethod deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder setManifestUrl(@Nullable String manifestUrl) {
            this.manifestUrl = manifestUrl;
            return this;
        }

        public Builder setIsVideoOnly(boolean isVideoOnly) {
            this.isVideoOnly = isVideoOnly;
            return this;
        }

        public Builder setResolution(@Nonnull String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder setItagItem(@Nullable ItagItem itagItem) {
            this.itagItem = itagItem;
            return this;
        }

        @Nonnull
        public VideoStream build() {
            if (this.id == null) {
                throw new IllegalStateException("The identifier of the video stream has been not set or is null. If you are not able to get an identifier, use the static constant ID_UNKNOWN of the Stream class.");
            }
            if (this.content == null) {
                throw new IllegalStateException("The content of the video stream has been not set or is null. Please specify a non-null one with setContent.");
            }
            if (this.deliveryMethod == null) {
                throw new IllegalStateException("The delivery method of the video stream has been set as null, which is not allowed. Pass a valid one instead with setDeliveryMethod.");
            }
            if (this.isVideoOnly == null) {
                throw new IllegalStateException("The video stream has been not set as a video-only stream or as a video stream with embedded audio. Please specify this information with setIsVideoOnly.");
            }
            if (this.resolution == null) {
                throw new IllegalStateException("The resolution of the video stream has been not set. Please specify it with setResolution (use an empty string if you are not able to get it).");
            }
            return new VideoStream(this.id, this.content, this.isUrl, this.mediaFormat, this.deliveryMethod, this.resolution, this.isVideoOnly, this.manifestUrl, this.itagItem);
        }
    }
}

