/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.util.Locale;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.LocaleCompat;

public final class SubtitlesStream
extends Stream {
    private final MediaFormat format;
    private final Locale locale;
    private final boolean autoGenerated;
    private final String code;

    private SubtitlesStream(@Nonnull String id2, @Nonnull String content, boolean isUrl, @Nullable MediaFormat mediaFormat, @Nonnull DeliveryMethod deliveryMethod, @Nonnull String languageCode, boolean autoGenerated, @Nullable String manifestUrl) throws ParsingException {
        super(id2, content, isUrl, mediaFormat, deliveryMethod, manifestUrl);
        this.locale = LocaleCompat.forLanguageTag(languageCode).orElseThrow(() -> new ParsingException("not a valid locale language code: " + languageCode));
        this.code = languageCode;
        this.format = mediaFormat;
        this.autoGenerated = autoGenerated;
    }

    public String getExtension() {
        return this.format.suffix;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    @Override
    public boolean equalStats(Stream cmp) {
        return super.equalStats(cmp) && cmp instanceof SubtitlesStream && this.code.equals(((SubtitlesStream)cmp).code) && this.autoGenerated == ((SubtitlesStream)cmp).autoGenerated;
    }

    public String getDisplayLanguageName() {
        return this.locale.getDisplayName(this.locale);
    }

    public String getLanguageTag() {
        return this.code;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    @Nullable
    public ItagItem getItagItem() {
        return null;
    }

    public static final class Builder {
        private String id;
        private String content;
        private boolean isUrl;
        private DeliveryMethod deliveryMethod = DeliveryMethod.PROGRESSIVE_HTTP;
        @Nullable
        private MediaFormat mediaFormat;
        @Nullable
        private String manifestUrl;
        private String languageCode;
        private Boolean autoGenerated;

        public Builder setId(@Nonnull String id2) {
            this.id = id2;
            return this;
        }

        public Builder setContent(@Nonnull String content, boolean isUrl) {
            this.content = content;
            this.isUrl = isUrl;
            return this;
        }

        public Builder setMediaFormat(@Nullable MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        public Builder setDeliveryMethod(@Nonnull DeliveryMethod deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder setManifestUrl(@Nullable String manifestUrl) {
            this.manifestUrl = manifestUrl;
            return this;
        }

        public Builder setLanguageCode(@Nonnull String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder setAutoGenerated(boolean autoGenerated) {
            this.autoGenerated = autoGenerated;
            return this;
        }

        @Nonnull
        public SubtitlesStream build() throws ParsingException {
            if (this.content == null) {
                throw new IllegalStateException("No valid content was specified. Please specify a valid one with setContent.");
            }
            if (this.deliveryMethod == null) {
                throw new IllegalStateException("The delivery method of the subtitles stream has been set as null, which is not allowed. Pass a valid one instead withsetDeliveryMethod.");
            }
            if (this.languageCode == null) {
                throw new IllegalStateException("The language code of the subtitles stream has been not set or is null. Make sure you specified an non null language code with setLanguageCode.");
            }
            if (this.autoGenerated == null) {
                throw new IllegalStateException("The subtitles stream has been not set as an autogenerated subtitles stream or not. Please specify this information with setIsAutoGenerated.");
            }
            if (this.id == null) {
                this.id = this.languageCode + (String)(this.mediaFormat != null ? "." + this.mediaFormat.suffix : "");
            }
            return new SubtitlesStream(this.id, this.content, this.isUrl, this.mediaFormat, this.deliveryMethod, this.languageCode, this.autoGenerated, this.manifestUrl);
        }
    }
}

