/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.stream;

import java.util.Locale;
import java.util.Objects;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioTrackType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.DeliveryMethod;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Stream;

public final class AudioStream
extends Stream {
    public static final int UNKNOWN_BITRATE = -1;
    private final int averageBitrate;
    private int itag = -1;
    private int bitrate;
    private int initStart;
    private int initEnd;
    private int indexStart;
    private int indexEnd;
    private String quality;
    private String codec;
    @Nullable
    private final String audioTrackId;
    @Nullable
    private final String audioTrackName;
    @Nullable
    private final Locale audioLocale;
    @Nullable
    private final AudioTrackType audioTrackType;
    @Nullable
    private ItagItem itagItem;

    private AudioStream(@Nonnull String id2, @Nonnull String content, boolean isUrl, @Nullable MediaFormat format, @Nonnull DeliveryMethod deliveryMethod, int averageBitrate, @Nullable String manifestUrl, @Nullable String audioTrackId, @Nullable String audioTrackName, @Nullable Locale audioLocale, @Nullable AudioTrackType audioTrackType, @Nullable ItagItem itagItem) {
        super(id2, content, isUrl, format, deliveryMethod, manifestUrl);
        if (itagItem != null) {
            this.itagItem = itagItem;
            this.itag = itagItem.id;
            this.quality = itagItem.getQuality();
            this.bitrate = itagItem.getBitrate();
            this.initStart = itagItem.getInitStart();
            this.initEnd = itagItem.getInitEnd();
            this.indexStart = itagItem.getIndexStart();
            this.indexEnd = itagItem.getIndexEnd();
            this.codec = itagItem.getCodec();
        }
        this.averageBitrate = averageBitrate;
        this.audioTrackId = audioTrackId;
        this.audioTrackName = audioTrackName;
        this.audioLocale = audioLocale;
        this.audioTrackType = audioTrackType;
    }

    @Override
    public boolean equalStats(Stream cmp) {
        return super.equalStats(cmp) && cmp instanceof AudioStream && this.averageBitrate == ((AudioStream)cmp).averageBitrate && Objects.equals(this.audioTrackId, ((AudioStream)cmp).audioTrackId) && this.audioTrackType == ((AudioStream)cmp).audioTrackType && Objects.equals(this.audioLocale, ((AudioStream)cmp).audioLocale);
    }

    public int getAverageBitrate() {
        return this.averageBitrate;
    }

    public int getItag() {
        return this.itag;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getInitStart() {
        return this.initStart;
    }

    public int getInitEnd() {
        return this.initEnd;
    }

    public int getIndexStart() {
        return this.indexStart;
    }

    public int getIndexEnd() {
        return this.indexEnd;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getCodec() {
        return this.codec;
    }

    @Nullable
    public String getAudioTrackId() {
        return this.audioTrackId;
    }

    @Nullable
    public String getAudioTrackName() {
        return this.audioTrackName;
    }

    @Nullable
    public Locale getAudioLocale() {
        return this.audioLocale;
    }

    @Nullable
    public AudioTrackType getAudioTrackType() {
        return this.audioTrackType;
    }

    @Override
    @Nullable
    public ItagItem getItagItem() {
        return this.itagItem;
    }

    public static final class Builder {
        private String id;
        private String content;
        private boolean isUrl;
        private DeliveryMethod deliveryMethod = DeliveryMethod.PROGRESSIVE_HTTP;
        @Nullable
        private MediaFormat mediaFormat;
        @Nullable
        private String manifestUrl;
        private int averageBitrate = -1;
        @Nullable
        private String audioTrackId;
        @Nullable
        private String audioTrackName;
        @Nullable
        private Locale audioLocale;
        @Nullable
        private AudioTrackType audioTrackType;
        @Nullable
        private ItagItem itagItem;

        public Builder setId(@Nonnull String id2) {
            this.id = id2;
            return this;
        }

        public Builder setContent(@Nonnull String content, boolean isUrl) {
            this.content = content;
            this.isUrl = isUrl;
            return this;
        }

        public Builder setMediaFormat(@Nullable MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        public Builder setDeliveryMethod(@Nonnull DeliveryMethod deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder setManifestUrl(@Nullable String manifestUrl) {
            this.manifestUrl = manifestUrl;
            return this;
        }

        public Builder setAverageBitrate(int averageBitrate) {
            this.averageBitrate = averageBitrate;
            return this;
        }

        public Builder setAudioTrackId(@Nullable String audioTrackId) {
            this.audioTrackId = audioTrackId;
            return this;
        }

        public Builder setAudioTrackName(@Nullable String audioTrackName) {
            this.audioTrackName = audioTrackName;
            return this;
        }

        public Builder setAudioTrackType(AudioTrackType audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        public Builder setAudioLocale(@Nullable Locale audioLocale) {
            this.audioLocale = audioLocale;
            return this;
        }

        public Builder setItagItem(@Nullable ItagItem itagItem) {
            this.itagItem = itagItem;
            return this;
        }

        @Nonnull
        public AudioStream build() {
            if (this.id == null) {
                throw new IllegalStateException("The identifier of the audio stream has been not set or is null. If you are not able to get an identifier, use the static constant ID_UNKNOWN of the Stream class.");
            }
            if (this.content == null) {
                throw new IllegalStateException("The content of the audio stream has been not set or is null. Please specify a non-null one with setContent.");
            }
            if (this.deliveryMethod == null) {
                throw new IllegalStateException("The delivery method of the audio stream has been set as null, which is not allowed. Pass a valid one instead with setDeliveryMethod.");
            }
            return new AudioStream(this.id, this.content, this.isUrl, this.mediaFormat, this.deliveryMethod, this.averageBitrate, this.manifestUrl, this.audioTrackId, this.audioTrackName, this.audioLocale, this.audioTrackType, this.itagItem);
        }
    }
}

