/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeSearchQueryHandlerFactory
extends SearchQueryHandlerFactory {
    private static final YoutubeSearchQueryHandlerFactory INSTANCE = new YoutubeSearchQueryHandlerFactory();
    public static final String ALL = "all";
    public static final String VIDEOS = "videos";
    public static final String CHANNELS = "channels";
    public static final String PLAYLISTS = "playlists";
    public static final String MUSIC_SONGS = "music_songs";
    public static final String MUSIC_VIDEOS = "music_videos";
    public static final String MUSIC_ALBUMS = "music_albums";
    public static final String MUSIC_PLAYLISTS = "music_playlists";
    public static final String MUSIC_ARTISTS = "music_artists";
    private static final String SEARCH_URL = "https://www.youtube.com/results?search_query=";
    private static final String MUSIC_SEARCH_URL = "https://music.youtube.com/search?q=";

    @Nonnull
    public static YoutubeSearchQueryHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String searchString, @Nonnull List<String> contentFilters, String sortFilter) throws ParsingException, UnsupportedOperationException {
        String contentFilter;
        switch (contentFilter = !contentFilters.isEmpty() ? contentFilters.get(0) : "") {
            case "videos": {
                return SEARCH_URL + Utils.encodeUrlUtf8(searchString) + "&sp=EgIQAfABAQ%253D%253D";
            }
            case "channels": {
                return SEARCH_URL + Utils.encodeUrlUtf8(searchString) + "&sp=EgIQAvABAQ%253D%253D";
            }
            case "playlists": {
                return SEARCH_URL + Utils.encodeUrlUtf8(searchString) + "&sp=EgIQA_ABAQ%253D%253D";
            }
            case "music_songs": 
            case "music_videos": 
            case "music_albums": 
            case "music_playlists": 
            case "music_artists": {
                return MUSIC_SEARCH_URL + Utils.encodeUrlUtf8(searchString);
            }
        }
        return SEARCH_URL + Utils.encodeUrlUtf8(searchString) + "&sp=8AEB";
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{ALL, VIDEOS, CHANNELS, PLAYLISTS, MUSIC_SONGS, MUSIC_VIDEOS, MUSIC_ALBUMS, MUSIC_PLAYLISTS};
    }

    @Nonnull
    public static String getSearchParameter(String contentFilter) {
        if (Utils.isNullOrEmpty(contentFilter)) {
            return "8AEB";
        }
        switch (contentFilter) {
            case "videos": {
                return "EgIQAfABAQ%3D%3D";
            }
            case "channels": {
                return "EgIQAvABAQ%3D%3D";
            }
            case "playlists": {
                return "EgIQA_ABAQ%3D%3D";
            }
            case "music_songs": 
            case "music_videos": 
            case "music_albums": 
            case "music_playlists": 
            case "music_artists": {
                return "";
            }
        }
        return "8AEB";
    }
}

