/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.UnsupportedTabException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;

public final class YoutubeChannelTabLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final YoutubeChannelTabLinkHandlerFactory INSTANCE = new YoutubeChannelTabLinkHandlerFactory();

    private YoutubeChannelTabLinkHandlerFactory() {
    }

    public static YoutubeChannelTabLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static String getUrlSuffix(@Nonnull String tab) throws UnsupportedTabException {
        switch (tab) {
            case "videos": {
                return "/videos";
            }
            case "shorts": {
                return "/shorts";
            }
            case "livestreams": {
                return "/streams";
            }
            case "albums": {
                return "/releases";
            }
            case "playlists": {
                return "/playlists";
            }
        }
        throw new UnsupportedTabException(tab);
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return "https://www.youtube.com/" + id2 + YoutubeChannelTabLinkHandlerFactory.getUrlSuffix(contentFilter.get(0));
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return YoutubeChannelLinkHandlerFactory.getInstance().getId(url);
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        try {
            this.getId(url);
        }
        catch (ParsingException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{"videos", "shorts", "livestreams", "albums", "playlists"};
    }
}

