/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeTrendingExtractor
extends KioskExtractor<StreamInfoItem> {
    public static final String KIOSK_ID = "Trending";
    private JsonObject initialData;
    private static final String VIDEOS_TAB_PARAMS = "4gIOGgxtb3N0X3BvcHVsYXI%3D";

    public YoutubeTrendingExtractor(StreamingService service, ListLinkHandler linkHandler, String kioskId) {
        super(service, linkHandler, kioskId);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        byte[] body = JsonWriter.string(((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(this.getExtractorLocalization(), this.getExtractorContentCountry()).value("browseId", "FEtrending")).value("params", VIDEOS_TAB_PARAMS)).done()).getBytes(StandardCharsets.UTF_8);
        this.initialData = YoutubeParsingHelper.getJsonPostResponse("browse", body, this.getExtractorLocalization());
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) {
        return ListExtractor.InfoItemsPage.emptyPage();
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        JsonObject header = this.initialData.getObject("header");
        String name = null;
        if (header.has("feedTabbedHeaderRenderer")) {
            name = YoutubeParsingHelper.getTextAtKey(header.getObject("feedTabbedHeaderRenderer"), "title");
        } else if (header.has("c4TabbedHeaderRenderer")) {
            name = YoutubeParsingHelper.getTextAtKey(header.getObject("c4TabbedHeaderRenderer"), "title");
        } else if (header.has("pageHeaderRenderer")) {
            name = YoutubeParsingHelper.getTextAtKey(header.getObject("pageHeaderRenderer"), "pageTitle");
        }
        if (Utils.isNullOrEmpty(name)) {
            throw new ParsingException("Could not get Trending name");
        }
        return name;
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws ParsingException {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        JsonObject tab = this.getTrendingTab();
        JsonObject tabContent = tab.getObject("content");
        boolean isVideoTab = tab.getObject("endpoint").getObject("browseEndpoint").getString("params", "").equals(VIDEOS_TAB_PARAMS);
        if (tabContent.has("richGridRenderer")) {
            tabContent.getObject("richGridRenderer").getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(content -> content.has("richItemRenderer")).map(content -> content.getObject("richItemRenderer").getObject("content").getObject("videoRenderer")).forEachOrdered(videoRenderer -> collector.commit(new YoutubeStreamInfoItemExtractor((JsonObject)videoRenderer, timeAgoParser)));
        } else if (tabContent.has("sectionListRenderer")) {
            Stream<JsonObject> shelves = tabContent.getObject("sectionListRenderer").getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).flatMap(content -> content.getObject("itemSectionRenderer").getArray("contents").stream()).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(content -> content.getObject("shelfRenderer"));
            Stream<JsonObject> items = isVideoTab ? shelves.findFirst().stream() : shelves.filter(shelfRenderer -> !shelfRenderer.has("title"));
            items.flatMap(shelfRenderer -> shelfRenderer.getObject("content").getObject("expandedShelfContentsRenderer").getArray("items").stream()).filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(item -> item.getObject("videoRenderer")).forEachOrdered(videoRenderer -> collector.commit(new YoutubeStreamInfoItemExtractor((JsonObject)videoRenderer, timeAgoParser)));
        }
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    private JsonObject getTrendingTab() throws ParsingException {
        return this.initialData.getObject("contents").getObject("twoColumnBrowseResultsRenderer").getArray("tabs").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(tab -> tab.getObject("tabRenderer")).filter(tabRenderer -> tabRenderer.getBoolean("selected")).filter(tabRenderer -> tabRenderer.has("content")).findFirst().orElseThrow(() -> new ParsingException("Could not get \"Now\" or \"Videos\" trending tab"));
    }
}

