/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.suggestion.SuggestionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeSuggestionExtractor
extends SuggestionExtractor {
    public YoutubeSuggestionExtractor(StreamingService service) {
        super(service);
    }

    @Override
    public List<String> suggestionList(String query) throws IOException, ExtractionException {
        String url = "https://suggestqueries-clients6.youtube.com/complete/search?client=youtube&ds=yt&gl=" + Utils.encodeUrlUtf8(this.getExtractorContentCountry().getCountryCode()) + "&q=" + Utils.encodeUrlUtf8(query) + "&xhr=t";
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Origin", Collections.singletonList("https://www.youtube.com"));
        headers.put("Referer", Collections.singletonList("https://www.youtube.com"));
        Response response = NewPipe.getDownloader().get(url, headers, this.getExtractorLocalization());
        String contentTypeHeader = response.getHeader("Content-Type");
        if (Utils.isNullOrEmpty(contentTypeHeader) || !contentTypeHeader.contains("application/json")) {
            throw new ExtractionException("Invalid response type (got \"" + contentTypeHeader + "\", excepted a JSON response) (response code " + response.responseCode() + ")");
        }
        String responseBody = response.responseBody();
        if (responseBody.isEmpty()) {
            throw new ExtractionException("Empty response received");
        }
        try {
            JsonArray suggestions = JsonParser.array().from(responseBody).getArray(1);
            return suggestions.stream().filter(JsonArray.class::isInstance).map(JsonArray.class::cast).map(suggestion -> suggestion.getString(0)).filter(suggestion -> !Utils.isBlank(suggestion)).collect(Collectors.toUnmodifiableList());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse JSON response", e);
        }
    }
}

