/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeReelInfoItemExtractor
implements StreamInfoItemExtractor {
    @Nonnull
    private final JsonObject reelInfo;

    public YoutubeReelInfoItemExtractor(@Nonnull JsonObject reelInfo) {
        this.reelInfo = reelInfo;
    }

    @Override
    public String getName() throws ParsingException {
        return YoutubeParsingHelper.getTextFromObject(this.reelInfo.getObject("headline"));
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            String videoId = this.reelInfo.getString("videoId");
            return YoutubeStreamLinkHandlerFactory.getInstance().getUrl(videoId);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get URL", e);
        }
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return YoutubeParsingHelper.getThumbnailsFromInfoItem(this.reelInfo);
    }

    @Override
    public StreamType getStreamType() throws ParsingException {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public long getViewCount() throws ParsingException {
        String viewCountText = YoutubeParsingHelper.getTextFromObject(this.reelInfo.getObject("viewCountText"));
        if (!Utils.isNullOrEmpty(viewCountText)) {
            if (viewCountText.toLowerCase().contains("no views")) {
                return 0L;
            }
            return Utils.mixedNumberWordToLong(viewCountText);
        }
        throw new ParsingException("Could not get short view count");
    }

    @Override
    public boolean isShortFormContent() {
        return true;
    }

    @Override
    public boolean isAd() throws ParsingException {
        return false;
    }

    @Override
    public long getDuration() throws ParsingException {
        return -1L;
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return null;
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        return null;
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nullable
    public String getTextualUploadDate() throws ParsingException {
        return null;
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        return null;
    }
}

