/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMusicAlbumOrPlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private final JsonObject albumOrPlaylistInfoItem;
    private final JsonObject descriptionElementUploader;

    public YoutubeMusicAlbumOrPlaylistInfoItemExtractor(JsonObject albumOrPlaylistInfoItem, JsonArray descriptionElements, String searchType) {
        this.albumOrPlaylistInfoItem = albumOrPlaylistInfoItem;
        this.descriptionElementUploader = descriptionElements.getObject("music_albums".equals(searchType) ? 2 : 0);
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.albumOrPlaylistInfoItem.getObject("thumbnail").getObject("musicThumbnailRenderer").getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.albumOrPlaylistInfoItem.getArray("flexColumns").getObject(0).getObject("musicResponsiveListItemFlexColumnRenderer").getObject("text"));
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get name");
    }

    @Override
    public String getUrl() throws ParsingException {
        String playlistId = this.albumOrPlaylistInfoItem.getObject("menu").getObject("menuRenderer").getArray("items").getObject(4).getObject("toggleMenuServiceItemRenderer").getObject("toggledServiceEndpoint").getObject("likeEndpoint").getObject("target").getString("playlistId");
        if (Utils.isNullOrEmpty(playlistId)) {
            playlistId = this.albumOrPlaylistInfoItem.getObject("overlay").getObject("musicItemThumbnailOverlayRenderer").getObject("content").getObject("musicPlayButtonRenderer").getObject("playNavigationEndpoint").getObject("watchPlaylistEndpoint").getString("playlistId");
        }
        if (!Utils.isNullOrEmpty(playlistId)) {
            return "https://music.youtube.com/playlist?list=" + playlistId;
        }
        throw new ParsingException("Could not get URL");
    }

    @Override
    public String getUploaderName() throws ParsingException {
        String name = this.descriptionElementUploader.getString("text");
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        throw new ParsingException("Could not get uploader name");
    }

    @Override
    @Nullable
    public String getUploaderUrl() throws ParsingException {
        JsonArray items = this.albumOrPlaylistInfoItem.getObject("menu").getObject("menuRenderer").getArray("items");
        for (Object item : items) {
            JsonObject menuNavigationItemRenderer = ((JsonObject)item).getObject("menuNavigationItemRenderer");
            if (!menuNavigationItemRenderer.getObject("icon").getString("iconType", "").equals("ARTIST")) continue;
            return YoutubeParsingHelper.getUrlFromNavigationEndpoint(menuNavigationItemRenderer.getObject("navigationEndpoint"));
        }
        if (!this.descriptionElementUploader.has("navigationEndpoint")) {
            return null;
        }
        return YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.descriptionElementUploader.getObject("navigationEndpoint"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() throws ParsingException {
        return -1L;
    }
}

