/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeDescriptionHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

class YoutubeCommentsEUVMInfoItemExtractor
implements CommentsInfoItemExtractor {
    private static final String AUTHOR = "author";
    private static final String PROPERTIES = "properties";
    @Nonnull
    private final JsonObject commentViewModel;
    @Nullable
    private final JsonObject commentRepliesRenderer;
    @Nonnull
    private final JsonObject commentEntityPayload;
    @Nonnull
    private final JsonObject engagementToolbarStateEntityPayload;
    @Nonnull
    private final String videoUrl;
    @Nonnull
    private final TimeAgoParser timeAgoParser;

    YoutubeCommentsEUVMInfoItemExtractor(@Nonnull JsonObject commentViewModel, @Nullable JsonObject commentRepliesRenderer, @Nonnull JsonObject commentEntityPayload, @Nonnull JsonObject engagementToolbarStateEntityPayload, @Nonnull String videoUrl, @Nonnull TimeAgoParser timeAgoParser) {
        this.commentViewModel = commentViewModel;
        this.commentRepliesRenderer = commentRepliesRenderer;
        this.commentEntityPayload = commentEntityPayload;
        this.engagementToolbarStateEntityPayload = engagementToolbarStateEntityPayload;
        this.videoUrl = videoUrl;
        this.timeAgoParser = timeAgoParser;
    }

    @Override
    public String getName() throws ParsingException {
        return this.getUploaderName();
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.videoUrl;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return this.getUploaderAvatars();
    }

    @Override
    public int getLikeCount() throws ParsingException {
        String textualLikeCount = this.getTextualLikeCount();
        try {
            if (Utils.isBlank(textualLikeCount)) {
                return 0;
            }
            return (int)Utils.mixedNumberWordToLong(textualLikeCount);
        }
        catch (Exception e) {
            throw new ParsingException("Unexpected error while converting textual like count to like count", e);
        }
    }

    @Override
    public String getTextualLikeCount() {
        return this.commentEntityPayload.getObject("toolbar").getString("likeCountNotliked");
    }

    @Override
    public Description getCommentText() throws ParsingException {
        return new Description(YoutubeDescriptionHelper.attributedDescriptionToHtml(this.commentEntityPayload.getObject(PROPERTIES).getObject("content")), 1);
    }

    @Override
    public String getTextualUploadDate() throws ParsingException {
        return this.commentEntityPayload.getObject(PROPERTIES).getString("publishedTime");
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        String textualPublishedTime = this.getTextualUploadDate();
        if (Utils.isNullOrEmpty(textualPublishedTime)) {
            return null;
        }
        return this.timeAgoParser.parse(textualPublishedTime);
    }

    @Override
    public String getCommentId() throws ParsingException {
        String commentId = this.commentEntityPayload.getObject(PROPERTIES).getString("org.watermedia.shaded.commentId");
        if (Utils.isNullOrEmpty(commentId) && Utils.isNullOrEmpty(commentId = this.commentViewModel.getString("org.watermedia.shaded.commentId"))) {
            throw new ParsingException("Could not get comment ID");
        }
        return commentId;
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        JsonObject author = this.commentEntityPayload.getObject(AUTHOR);
        String channelId = author.getString("channelId");
        if (Utils.isNullOrEmpty(channelId) && Utils.isNullOrEmpty(channelId = author.getObject("channelCommand").getObject("innertubeCommand").getObject("browseEndpoint").getString("browseId")) && Utils.isNullOrEmpty(channelId = author.getObject("avatar").getObject("endpoint").getObject("innertubeCommand").getObject("browseEndpoint").getString("browseId"))) {
            throw new ParsingException("Could not get channel ID");
        }
        return "https://www.youtube.com/channel/" + channelId;
    }

    @Override
    public String getUploaderName() throws ParsingException {
        return this.commentEntityPayload.getObject(AUTHOR).getString("displayName");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.commentEntityPayload.getObject("avatar").getObject("image").getArray("sources"));
    }

    @Override
    public boolean isHeartedByUploader() {
        return "TOOLBAR_HEART_STATE_HEARTED".equals(this.engagementToolbarStateEntityPayload.getString("heartState"));
    }

    @Override
    public boolean isPinned() {
        return this.commentViewModel.has("pinnedText");
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        JsonObject author = this.commentEntityPayload.getObject(AUTHOR);
        return author.getBoolean("isVerified") || author.getBoolean("isArtist");
    }

    @Override
    public int getReplyCount() throws ParsingException {
        String replyCountString = this.commentEntityPayload.getObject("toolbar").getString("replyCount");
        if (Utils.isNullOrEmpty(replyCountString)) {
            return 0;
        }
        return (int)Utils.mixedNumberWordToLong(replyCountString);
    }

    @Override
    @Nullable
    public Page getReplies() throws ParsingException {
        if (Utils.isNullOrEmpty(this.commentRepliesRenderer)) {
            return null;
        }
        String continuation = this.commentRepliesRenderer.getArray("contents").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(content -> content.getObject("continuationItemRenderer", null)).filter(Objects::nonNull).findFirst().map(continuationItemRenderer -> continuationItemRenderer.getObject("continuationEndpoint").getObject("continuationCommand").getString("token")).orElseThrow(() -> new ParsingException("Could not get comment replies continuation"));
        return new Page(this.videoUrl, continuation);
    }

    @Override
    public boolean isChannelOwner() {
        return this.commentEntityPayload.getObject(AUTHOR).getBoolean("isCreator");
    }

    @Override
    public boolean hasCreatorReply() {
        return this.commentRepliesRenderer != null && this.commentRepliesRenderer.has("viewRepliesCreatorThumbnail");
    }
}

