/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubePlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelTabPlaylistExtractor
extends ChannelTabExtractor {
    private final PlaylistExtractor playlistExtractorInstance;
    private boolean playlistExisting;

    public YoutubeChannelTabPlaylistExtractor(@Nonnull StreamingService service, @Nonnull ListLinkHandler linkHandler) throws IllegalArgumentException, SystemPlaylistUrlCreationException {
        super(service, linkHandler);
        ListLinkHandler playlistLinkHandler = this.getPlaylistLinkHandler(linkHandler);
        this.playlistExtractorInstance = new YoutubePlaylistExtractor(service, playlistLinkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        try {
            this.playlistExtractorInstance.onFetchPage(downloader);
            if (!this.playlistExisting) {
                this.playlistExisting = true;
            }
        }
        catch (ContentNotAvailableException contentNotAvailableException) {
            // empty catch block
        }
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage getInitialPage() throws IOException, ExtractionException {
        if (!this.playlistExisting) {
            return ListExtractor.InfoItemsPage.emptyPage();
        }
        return this.playlistExtractorInstance.getInitialPage();
    }

    @Override
    public ListExtractor.InfoItemsPage getPage(Page page) throws IOException, ExtractionException {
        if (!this.playlistExisting) {
            return ListExtractor.InfoItemsPage.emptyPage();
        }
        return this.playlistExtractorInstance.getPage(page);
    }

    @Nonnull
    private ListLinkHandler getPlaylistLinkHandler(@Nonnull ListLinkHandler originalLinkHandler) throws IllegalArgumentException, SystemPlaylistUrlCreationException {
        String playlistId;
        List<String> contentFilters = originalLinkHandler.getContentFilters();
        if (contentFilters.isEmpty()) {
            throw new IllegalArgumentException("A content filter is required");
        }
        String channelId = originalLinkHandler.getId();
        if (Utils.isNullOrEmpty(channelId) || !channelId.startsWith("UC")) {
            throw new IllegalArgumentException("Invalid channel ID");
        }
        String channelIdWithoutUc = channelId.substring(2);
        switch (contentFilters.get(0)) {
            case "videos": {
                playlistId = "UULF" + channelIdWithoutUc;
                break;
            }
            case "shorts": {
                playlistId = "UUSH" + channelIdWithoutUc;
                break;
            }
            case "livestreams": {
                playlistId = "UULV" + channelIdWithoutUc;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only Videos, Shorts and Livestreams tabs can extracted as playlists");
            }
        }
        try {
            String newUrl = YoutubePlaylistLinkHandlerFactory.getInstance().getUrl(playlistId);
            return new ListLinkHandler(newUrl, newUrl, playlistId, List.of(), "");
        }
        catch (ParsingException e) {
            throw new SystemPlaylistUrlCreationException("Could not create a YouTube playlist from a valid playlist ID", e);
        }
    }

    public static final class SystemPlaylistUrlCreationException
    extends RuntimeException {
        SystemPlaylistUrlCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

