/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelInfoItemExtractor
implements ChannelInfoItemExtractor {
    private final JsonObject channelInfoItem;
    private final boolean withHandle;

    public YoutubeChannelInfoItemExtractor(JsonObject channelInfoItem) {
        this.channelInfoItem = channelInfoItem;
        boolean wHandle = false;
        String subscriberCountText = YoutubeParsingHelper.getTextFromObject(channelInfoItem.getObject("subscriberCountText"));
        if (subscriberCountText != null) {
            wHandle = subscriberCountText.startsWith("@");
        }
        this.withHandle = wHandle;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            return YoutubeParsingHelper.getThumbnailsFromInfoItem(this.channelInfoItem);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(this.channelInfoItem.getObject("title"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get name", e);
        }
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            String id2 = "channel/" + this.channelInfoItem.getString("channelId");
            return YoutubeChannelLinkHandlerFactory.getInstance().getUrl(id2);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get url", e);
        }
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        try {
            if (!this.channelInfoItem.has("subscriberCountText")) {
                return -1L;
            }
            if (this.withHandle) {
                if (this.channelInfoItem.has("videoCountText")) {
                    return Utils.mixedNumberWordToLong(YoutubeParsingHelper.getTextFromObject(this.channelInfoItem.getObject("videoCountText")));
                }
                return -1L;
            }
            return Utils.mixedNumberWordToLong(YoutubeParsingHelper.getTextFromObject(this.channelInfoItem.getObject("subscriberCountText")));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get subscriber count", e);
        }
    }

    @Override
    public long getStreamCount() throws ParsingException {
        try {
            if (this.withHandle || !this.channelInfoItem.has("videoCountText")) {
                return -1L;
            }
            return Long.parseLong(Utils.removeNonDigitCharacters(YoutubeParsingHelper.getTextFromObject(this.channelInfoItem.getObject("videoCountText"))));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get stream count", e);
        }
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return YoutubeParsingHelper.isVerified(this.channelInfoItem.getArray("ownerBadges"));
    }

    @Override
    public String getDescription() throws ParsingException {
        try {
            if (!this.channelInfoItem.has("descriptionSnippet")) {
                return null;
            }
            return YoutubeParsingHelper.getTextFromObject(this.channelInfoItem.getObject("descriptionSnippet"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get description", e);
        }
    }
}

