/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JavaScript;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.jsextractor.JavaScriptExtractor;

final class YoutubeThrottlingParameterUtils {
    private static final Pattern THROTTLING_PARAM_PATTERN = Pattern.compile("[&?]n=([^&]+)");
    private static final String SINGLE_CHAR_VARIABLE_REGEX = "[a-zA-Z0-9$_]";
    private static final String MULTIPLE_CHARS_REGEX = "[a-zA-Z0-9$_]+";
    private static final String ARRAY_ACCESS_REGEX = "\\[(\\d+)]";
    private static final Pattern[] DEOBFUSCATION_FUNCTION_NAME_REGEXES = new Pattern[]{Pattern.compile("([A-Za-z0-9_\\$]{2,})=function.*return [A-Z]\\[\\d+\\]"), Pattern.compile("[a-zA-Z0-9$_]=\"nn\"\\[\\+[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+],[a-zA-Z0-9$_]+\\([a-zA-Z0-9$_]+\\),[a-zA-Z0-9$_]+=[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+\\[[a-zA-Z0-9$_]+]\\|\\|null\\)&&\\([a-zA-Z0-9$_]+=([a-zA-Z0-9$_]+)\\[(\\d+)]"), Pattern.compile("[a-zA-Z0-9$_]=\"nn\"\\[\\+[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+],[a-zA-Z0-9$_]+\\([a-zA-Z0-9$_]+\\),[a-zA-Z0-9$_]+=[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+\\[[a-zA-Z0-9$_]+]\\|\\|null\\).+\\|\\|([a-zA-Z0-9$_]+)\\(\"\"\\)"), Pattern.compile(",[a-zA-Z0-9$_]+\\([a-zA-Z0-9$_]+\\),[a-zA-Z0-9$_]+=[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+\\[[a-zA-Z0-9$_]+]\\|\\|null\\)&&\\(\\b[a-zA-Z0-9$_]+=([a-zA-Z0-9$_]+)\\[(\\d+)]\\([a-zA-Z0-9$_]\\),[a-zA-Z0-9$_]+\\.set\\((?:\"n+\"|[a-zA-Z0-9$_]+),[a-zA-Z0-9$_]+\\)"), Pattern.compile("[a-zA-Z0-9$_]=\"nn\"\\[\\+[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+],[a-zA-Z0-9$_]+=[a-zA-Z0-9$_]+\\.get\\([a-zA-Z0-9$_]+\\)\\).+\\|\\|([a-zA-Z0-9$_]+)\\(\"\"\\)"), Pattern.compile("[a-zA-Z0-9$_]=\"nn\"\\[\\+[a-zA-Z0-9$_]+\\.[a-zA-Z0-9$_]+],[a-zA-Z0-9$_]+=[a-zA-Z0-9$_]+\\.get\\([a-zA-Z0-9$_]+\\)\\)&&\\([a-zA-Z0-9$_]+=([a-zA-Z0-9$_]+)\\[(\\d+)]"), Pattern.compile("\\([a-zA-Z0-9$_]=String\\.fromCharCode\\(110\\),[a-zA-Z0-9$_]=[a-zA-Z0-9$_]\\.get\\([a-zA-Z0-9$_]\\)\\)&&\\([a-zA-Z0-9$_]=([a-zA-Z0-9$_]+)(?:\\[(\\d+)])?\\([a-zA-Z0-9$_]\\)"), Pattern.compile("\\.get\\(\"n\"\\)\\)&&\\([a-zA-Z0-9$_]=([a-zA-Z0-9$_]+)(?:\\[(\\d+)])?\\([a-zA-Z0-9$_]\\)")};
    private static final String DEOBFUSCATION_FUNCTION_BODY_REGEX = "=\\s*function([\\S\\s]*?\\}\\s*return [\\w$]+?\\.join\\(\"\"\\)\\s*\\};)";
    private static final String DEOBFUSCATION_FUNCTION_ARRAY_OBJECT_TYPE_DECLARATION_REGEX = "var ";
    private static final String FUNCTION_NAMES_IN_DEOBFUSCATION_ARRAY_REGEX = "\\s*=\\s*\\[(.+?)][;,]";
    private static final String FUNCTION_ARGUMENTS_REGEX = "=\\s*function\\s*\\(\\s*([^)]*)\\s*\\)";
    private static final String EARLY_RETURN_REGEX = ";\\s*if\\s*\\(\\s*typeof\\s+[a-zA-Z0-9$_]++\\s*===?\\s*([\"'])undefined\\1\\s*\\)\\s*return\\s+";

    private YoutubeThrottlingParameterUtils() {
    }

    @Nonnull
    static String getDeobfuscationFunctionName(@Nonnull String javaScriptPlayerCode) throws ParsingException {
        Matcher matcher;
        try {
            matcher = Parser.matchMultiplePatterns(DEOBFUSCATION_FUNCTION_NAME_REGEXES, javaScriptPlayerCode);
        }
        catch (Parser.RegexException e) {
            throw new ParsingException("Could not find deobfuscation function with any of the known patterns in the base JavaScript player code", e);
        }
        String functionName = matcher.group(1);
        if (matcher.groupCount() == 1) {
            return functionName;
        }
        int arrayNum = Integer.parseInt(matcher.group(2));
        Pattern arrayPattern = Pattern.compile(DEOBFUSCATION_FUNCTION_ARRAY_OBJECT_TYPE_DECLARATION_REGEX + Pattern.quote(functionName) + FUNCTION_NAMES_IN_DEOBFUSCATION_ARRAY_REGEX);
        String arrayStr = Parser.matchGroup1(arrayPattern, javaScriptPlayerCode);
        String[] names = arrayStr.split(",");
        return names[arrayNum];
    }

    @Nonnull
    static String getDeobfuscationFunction(@Nonnull String javaScriptPlayerCode, @Nonnull String functionName) throws ParsingException {
        String function;
        try {
            function = YoutubeThrottlingParameterUtils.parseFunctionWithLexer(javaScriptPlayerCode, functionName);
        }
        catch (Exception e) {
            function = YoutubeThrottlingParameterUtils.parseFunctionWithRegex(javaScriptPlayerCode, functionName);
        }
        return YoutubeThrottlingParameterUtils.fixupFunction(function);
    }

    @Nullable
    static String getThrottlingParameterFromStreamingUrl(@Nonnull String streamingUrl) {
        if (!streamingUrl.contains("&n=") && !streamingUrl.contains("?n=")) {
            return null;
        }
        try {
            return Parser.matchGroup1(THROTTLING_PARAM_PATTERN, streamingUrl);
        }
        catch (Parser.RegexException e) {
            return null;
        }
    }

    @Nonnull
    private static String parseFunctionWithLexer(@Nonnull String javaScriptPlayerCode, @Nonnull String functionName) throws ParsingException {
        String functionBase = functionName + "=function";
        return functionBase + JavaScriptExtractor.matchToClosingBrace(javaScriptPlayerCode, functionBase) + ";";
    }

    @Nonnull
    private static String parseFunctionWithRegex(@Nonnull String javaScriptPlayerCode, @Nonnull String functionName) throws Parser.RegexException {
        Pattern functionPattern = Pattern.compile(Pattern.quote(functionName) + DEOBFUSCATION_FUNCTION_BODY_REGEX, 32);
        return YoutubeThrottlingParameterUtils.validateFunction("function " + functionName + Parser.matchGroup1(functionPattern, javaScriptPlayerCode));
    }

    @Nonnull
    private static String validateFunction(@Nonnull String function) {
        JavaScript.compileOrThrow(function);
        return function;
    }

    @Nonnull
    private static String fixupFunction(@Nonnull String function) throws Parser.RegexException {
        String firstArgName = Parser.matchGroup1(FUNCTION_ARGUMENTS_REGEX, function).split(",")[0].trim();
        Pattern earlyReturnPattern = Pattern.compile(EARLY_RETURN_REGEX + firstArgName + ";", 32);
        Matcher earlyReturnCodeMatcher = earlyReturnPattern.matcher(function);
        return earlyReturnCodeMatcher.replaceFirst(";");
    }
}

