/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.InnertubeClientRequestInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.PoTokenResult;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public final class YoutubeStreamHelper {
    private static final String PLAYER = "player";
    private static final String SERVICE_INTEGRITY_DIMENSIONS = "serviceIntegrityDimensions";
    private static final String PO_TOKEN = "poToken";
    private static final String BASE_YT_DESKTOP_WATCH_URL = "https://www.youtube.com/watch?v=";

    private YoutubeStreamHelper() {
    }

    @Nonnull
    public static JsonObject getWebMetadataPlayerResponse(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId) throws IOException, ExtractionException {
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofWebClient();
        innertubeClientRequestInfo.clientInfo.clientVersion = YoutubeParsingHelper.getClientVersion();
        Map<String, List<String>> headers = YoutubeParsingHelper.getYouTubeHeaders();
        innertubeClientRequestInfo.clientInfo.visitorData = YoutubeParsingHelper.getVisitorDataFromInnertube(innertubeClientRequestInfo, localization, contentCountry, headers, "https://www.youtube.com/youtubei/v1/", null, false);
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, null);
        YoutubeStreamHelper.addVideoIdCpnAndOkChecks(builder, videoId, null);
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String url = "https://www.youtube.com/youtubei/v1/player?prettyPrint=false&$fields=microformat,playabilityStatus,storyboards,videoDetails";
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson("https://www.youtube.com/youtubei/v1/player?prettyPrint=false&$fields=microformat,playabilityStatus,storyboards,videoDetails", headers, body, localization)));
    }

    @Nonnull
    public static JsonObject getWebEmbeddedPlayerResponse(@Nonnull Localization localization, @Nonnull ContentCountry contentCountry, @Nonnull String videoId, @Nonnull String cpn, @Nullable PoTokenResult webEmbeddedPoTokenResult, int signatureTimestamp) throws IOException, ExtractionException {
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofWebEmbeddedPlayerClient();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(YoutubeParsingHelper.getClientHeaders("56", "1.20250121.00.00"));
        headers.putAll(YoutubeParsingHelper.getOriginReferrerHeaders("https://www.youtube.com"));
        String embedUrl = BASE_YT_DESKTOP_WATCH_URL + videoId;
        innertubeClientRequestInfo.clientInfo.visitorData = webEmbeddedPoTokenResult == null ? YoutubeParsingHelper.getVisitorDataFromInnertube(innertubeClientRequestInfo, localization, contentCountry, headers, "https://www.youtube.com/youtubei/v1/", embedUrl, false) : webEmbeddedPoTokenResult.visitorData;
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, embedUrl);
        YoutubeStreamHelper.addVideoIdCpnAndOkChecks(builder, videoId, cpn);
        YoutubeStreamHelper.addPlaybackContext(builder, embedUrl, signatureTimestamp);
        if (webEmbeddedPoTokenResult != null) {
            YoutubeStreamHelper.addPoToken(builder, webEmbeddedPoTokenResult.playerRequestPoToken);
        }
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String url = "https://www.youtube.com/youtubei/v1/player?prettyPrint=false";
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson("https://www.youtube.com/youtubei/v1/player?prettyPrint=false", headers, body, localization)));
    }

    public static JsonObject getAndroidPlayerResponse(@Nonnull ContentCountry contentCountry, @Nonnull Localization localization, @Nonnull String videoId, @Nonnull String cpn, @Nonnull PoTokenResult androidPoTokenResult) throws IOException, ExtractionException {
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofAndroidClient();
        innertubeClientRequestInfo.clientInfo.visitorData = androidPoTokenResult.visitorData;
        Map<String, List<String>> headers = YoutubeStreamHelper.getMobileClientHeaders(YoutubeParsingHelper.getAndroidUserAgent(localization));
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, null);
        YoutubeStreamHelper.addVideoIdCpnAndOkChecks(builder, videoId, cpn);
        YoutubeStreamHelper.addPoToken(builder, androidPoTokenResult.playerRequestPoToken);
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String url = "https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false&t=" + YoutubeParsingHelper.generateTParameter() + "&id=" + videoId;
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(url, headers, body, localization)));
    }

    public static JsonObject getAndroidReelPlayerResponse(@Nonnull ContentCountry contentCountry, @Nonnull Localization localization, @Nonnull String videoId, @Nonnull String cpn) throws IOException, ExtractionException {
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofAndroidClient();
        Map<String, List<String>> headers = YoutubeStreamHelper.getMobileClientHeaders(YoutubeParsingHelper.getAndroidUserAgent(localization));
        innertubeClientRequestInfo.clientInfo.visitorData = YoutubeParsingHelper.getVisitorDataFromInnertube(innertubeClientRequestInfo, localization, contentCountry, headers, "https://youtubei.googleapis.com/youtubei/v1/", null, false);
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, null);
        builder.object("playerRequest");
        YoutubeStreamHelper.addVideoIdCpnAndOkChecks(builder, videoId, cpn);
        ((JsonBuilder)builder.end()).value("disablePlayerResponse", false);
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String url = "https://youtubei.googleapis.com/youtubei/v1/reel/reel_item_watch?prettyPrint=false&t=" + YoutubeParsingHelper.generateTParameter() + "&id=" + videoId + "&$fields=playerResponse";
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(url, headers, body, localization))).getObject("playerResponse");
    }

    public static JsonObject getIosPlayerResponse(@Nonnull ContentCountry contentCountry, @Nonnull Localization localization, @Nonnull String videoId, @Nonnull String cpn, @Nullable PoTokenResult iosPoTokenResult) throws IOException, ExtractionException {
        InnertubeClientRequestInfo innertubeClientRequestInfo = InnertubeClientRequestInfo.ofIosClient();
        Map<String, List<String>> headers = YoutubeStreamHelper.getMobileClientHeaders(YoutubeParsingHelper.getIosUserAgent(localization));
        innertubeClientRequestInfo.clientInfo.visitorData = iosPoTokenResult == null ? YoutubeParsingHelper.getVisitorDataFromInnertube(innertubeClientRequestInfo, localization, contentCountry, headers, "https://www.youtube.com/youtubei/v1/", null, false) : iosPoTokenResult.visitorData;
        JsonBuilder<JsonObject> builder = YoutubeParsingHelper.prepareJsonBuilder(localization, contentCountry, innertubeClientRequestInfo, null);
        YoutubeStreamHelper.addVideoIdCpnAndOkChecks(builder, videoId, cpn);
        if (iosPoTokenResult != null) {
            YoutubeStreamHelper.addPoToken(builder, iosPoTokenResult.playerRequestPoToken);
        }
        byte[] body = JsonWriter.string(builder.done()).getBytes(StandardCharsets.UTF_8);
        String url = "https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false&t=" + YoutubeParsingHelper.generateTParameter() + "&id=" + videoId;
        return JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(NewPipe.getDownloader().postWithContentTypeJson(url, headers, body, localization)));
    }

    private static void addVideoIdCpnAndOkChecks(@Nonnull JsonBuilder<JsonObject> builder, @Nonnull String videoId, @Nullable String cpn) {
        builder.value("videoId", videoId);
        if (cpn != null) {
            builder.value("cpn", cpn);
        }
        ((JsonBuilder)builder.value("contentCheckOk", true)).value("racyCheckOk", true);
    }

    private static void addPlaybackContext(@Nonnull JsonBuilder<JsonObject> builder, @Nonnull String referer, int signatureTimestamp) {
        ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)builder.object("playbackContext")).object("contentPlaybackContext")).value("signatureTimestamp", signatureTimestamp)).value("referer", referer)).end()).end();
    }

    private static void addPoToken(@Nonnull JsonBuilder<JsonObject> builder, @Nonnull String poToken) {
        ((JsonBuilder)((JsonBuilder)builder.object(SERVICE_INTEGRITY_DIMENSIONS)).value(PO_TOKEN, poToken)).end();
    }

    @Nonnull
    private static Map<String, List<String>> getMobileClientHeaders(@Nonnull String userAgent) {
        return Map.of("User-Agent", List.of(userAgent), "X-Goog-Api-Format-Version", List.of("2"));
    }
}

