/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.util.Arrays;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.feed.FeedExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskList;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ReadyChannelTabListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeCommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeFeedExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMixPlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeMusicSearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubePlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeSearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeSubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeSuggestionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeLiveExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeTrendingExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeTrendingGamingVideosExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeTrendingMoviesAndShowsTrailersExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeTrendingMusicExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.kiosk.YoutubeTrendingPodcastsEpisodesExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeCommentsLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeLiveLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeSearchQueryHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeStreamLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeTrendingGamingVideosLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeTrendingLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeTrendingMoviesAndShowsTrailersLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeTrendingMusicLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeTrendingPodcastsEpisodesLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.subscription.SubscriptionExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.suggestion.SuggestionExtractor;

public class YoutubeService
extends StreamingService {
    private static final List<Localization> SUPPORTED_LANGUAGES = Localization.listFrom("en-GB");
    private static final List<ContentCountry> SUPPORTED_COUNTRIES = ContentCountry.listFrom("DZ", "AR", "AU", "AT", "AZ", "BH", "BD", "BY", "BE", "BO", "BA", "BR", "BG", "KH", "CA", "CL", "CO", "CR", "HR", "CY", "CZ", "DK", "DO", "EC", "EG", "SV", "EE", "FI", "FR", "GE", "DE", "GH", "GR", "GT", "HN", "HK", "HU", "IS", "IN", "ID", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KW", "LA", "LV", "LB", "LY", "LI", "LT", "LU", "MY", "MT", "MX", "ME", "MA", "NP", "NL", "NZ", "NI", "NG", "MK", "NO", "OM", "PK", "PA", "PG", "PY", "PE", "PH", "PL", "PT", "PR", "QA", "RO", "RU", "SA", "SN", "RS", "SG", "SK", "SI", "ZA", "KR", "ES", "LK", "SE", "CH", "TW", "TZ", "TH", "TN", "TR", "UG", "UA", "AE", "GB", "US", "UY", "VE", "VN", "YE", "ZW");

    public YoutubeService(int id2) {
        super(id2, "YouTube", Arrays.asList(StreamingService.ServiceInfo.MediaCapability.AUDIO, StreamingService.ServiceInfo.MediaCapability.VIDEO, StreamingService.ServiceInfo.MediaCapability.LIVE, StreamingService.ServiceInfo.MediaCapability.COMMENTS));
    }

    @Override
    public String getBaseUrl() {
        return "https://youtube.com";
    }

    @Override
    public LinkHandlerFactory getStreamLHFactory() {
        return YoutubeStreamLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getChannelLHFactory() {
        return YoutubeChannelLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getChannelTabLHFactory() {
        return YoutubeChannelTabLinkHandlerFactory.getInstance();
    }

    @Override
    public ListLinkHandlerFactory getPlaylistLHFactory() {
        return YoutubePlaylistLinkHandlerFactory.getInstance();
    }

    @Override
    public SearchQueryHandlerFactory getSearchQHFactory() {
        return YoutubeSearchQueryHandlerFactory.getInstance();
    }

    @Override
    public StreamExtractor getStreamExtractor(LinkHandler linkHandler) {
        return new YoutubeStreamExtractor(this, linkHandler);
    }

    @Override
    public ChannelExtractor getChannelExtractor(ListLinkHandler linkHandler) {
        return new YoutubeChannelExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public ChannelTabExtractor getChannelTabExtractor(ListLinkHandler linkHandler) {
        if (linkHandler instanceof ReadyChannelTabListLinkHandler) {
            return ((ReadyChannelTabListLinkHandler)linkHandler).getChannelTabExtractor(this);
        }
        return new YoutubeChannelTabExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public PlaylistExtractor getPlaylistExtractor(ListLinkHandler linkHandler) {
        if (YoutubeParsingHelper.isYoutubeMixId(linkHandler.getId())) {
            return new YoutubeMixPlaylistExtractor((StreamingService)this, linkHandler);
        }
        return new YoutubePlaylistExtractor((StreamingService)this, linkHandler);
    }

    @Override
    public SearchExtractor getSearchExtractor(SearchQueryHandler query) {
        List<String> contentFilters = query.getContentFilters();
        if (!contentFilters.isEmpty() && contentFilters.get(0).startsWith("music_")) {
            return new YoutubeMusicSearchExtractor((StreamingService)this, query);
        }
        return new YoutubeSearchExtractor((StreamingService)this, query);
    }

    @Override
    public SuggestionExtractor getSuggestionExtractor() {
        return new YoutubeSuggestionExtractor(this);
    }

    @Override
    public KioskList getKioskList() throws ExtractionException {
        KioskList list = new KioskList(this);
        YoutubeTrendingLinkHandlerFactory trendingLHF = YoutubeTrendingLinkHandlerFactory.INSTANCE;
        YoutubeLiveLinkHandlerFactory runningLivesLHF = YoutubeLiveLinkHandlerFactory.INSTANCE;
        YoutubeTrendingPodcastsEpisodesLinkHandlerFactory trendingPodcastsEpisodesLHF = YoutubeTrendingPodcastsEpisodesLinkHandlerFactory.INSTANCE;
        YoutubeTrendingGamingVideosLinkHandlerFactory trendingGamingVideosLHF = YoutubeTrendingGamingVideosLinkHandlerFactory.INSTANCE;
        YoutubeTrendingMoviesAndShowsTrailersLinkHandlerFactory trendingMoviesAndShowsLHF = YoutubeTrendingMoviesAndShowsTrailersLinkHandlerFactory.INSTANCE;
        YoutubeTrendingMusicLinkHandlerFactory trendingMusicLHF = YoutubeTrendingMusicLinkHandlerFactory.INSTANCE;
        try {
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeLiveExtractor(this, runningLivesLHF.fromUrl(url), id2), runningLivesLHF, "live");
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeTrendingPodcastsEpisodesExtractor(this, trendingPodcastsEpisodesLHF.fromUrl(url), id2), trendingPodcastsEpisodesLHF, "trending_podcasts_episodes");
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeTrendingGamingVideosExtractor(this, trendingGamingVideosLHF.fromUrl(url), id2), trendingGamingVideosLHF, "trending_gaming");
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeTrendingMoviesAndShowsTrailersExtractor(this, trendingMoviesAndShowsLHF.fromUrl(url), id2), trendingMoviesAndShowsLHF, "trending_movies_and_shows");
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeTrendingMusicExtractor(this, trendingMusicLHF.fromUrl(url), id2), trendingMusicLHF, "trending_music");
            list.addKioskEntry((streamingService, url, id2) -> new YoutubeTrendingExtractor(this, trendingLHF.fromUrl(url), id2), trendingLHF, "Trending");
            list.setDefaultKiosk("live");
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return list;
    }

    @Override
    public SubscriptionExtractor getSubscriptionExtractor() {
        return new YoutubeSubscriptionExtractor(this);
    }

    @Override
    @Nonnull
    public FeedExtractor getFeedExtractor(String channelUrl) throws ExtractionException {
        return new YoutubeFeedExtractor((StreamingService)this, this.getChannelLHFactory().fromUrl(channelUrl));
    }

    @Override
    public ListLinkHandlerFactory getCommentsLHFactory() {
        return YoutubeCommentsLinkHandlerFactory.getInstance();
    }

    @Override
    public CommentsExtractor getCommentsExtractor(ListLinkHandler urlIdHandler) throws ExtractionException {
        return new YoutubeCommentsExtractor((StreamingService)this, urlIdHandler);
    }

    @Override
    public List<Localization> getSupportedLocalizations() {
        return SUPPORTED_LANGUAGES;
    }

    @Override
    public List<ContentCountry> getSupportedCountries() {
        return SUPPORTED_COUNTRIES;
    }
}

