/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.jsoup.select.Elements;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

final class YoutubeJavaScriptExtractor {
    private static final String HTTPS = "https:";
    private static final String BASE_JS_PLAYER_URL_FORMAT = "https://www.youtube.com/s/player/%s/player_ias.vflset/en_GB/base.js";
    private static final Pattern IFRAME_RES_JS_BASE_PLAYER_HASH_PATTERN = Pattern.compile("player\\\\/([a-z0-9]{8})\\\\/");
    private static final Pattern EMBEDDED_WATCH_PAGE_JS_BASE_PLAYER_URL_PATTERN = Pattern.compile("\"jsUrl\":\"(/s/player/[A-Za-z0-9]+/player_ias\\.vflset/[A-Za-z_-]+/base\\.js)\"");

    private YoutubeJavaScriptExtractor() {
    }

    @Nonnull
    static String extractJavaScriptPlayerCode(@Nonnull String videoId) throws ParsingException {
        try {
            String url = YoutubeJavaScriptExtractor.extractJavaScriptUrlWithIframeResource();
            String playerJsUrl = YoutubeJavaScriptExtractor.cleanJavaScriptUrl(url);
            new URL(playerJsUrl);
            return YoutubeJavaScriptExtractor.downloadJavaScriptCode(playerJsUrl);
        }
        catch (Exception e) {
            String url = YoutubeJavaScriptExtractor.extractJavaScriptUrlWithEmbedWatchPage(videoId);
            String playerJsUrl = YoutubeJavaScriptExtractor.cleanJavaScriptUrl(url);
            try {
                new URL(playerJsUrl);
            }
            catch (MalformedURLException exception) {
                throw new ParsingException("The extracted and built JavaScript URL is invalid", exception);
            }
            return YoutubeJavaScriptExtractor.downloadJavaScriptCode(playerJsUrl);
        }
    }

    @Nonnull
    static String extractJavaScriptUrlWithIframeResource() throws ParsingException {
        String iframeContent;
        try {
            String iframeUrl = "https://www.youtube.com/iframe_api";
            iframeContent = NewPipe.getDownloader().get(iframeUrl, Localization.DEFAULT).responseBody();
        }
        catch (Exception e) {
            throw new ParsingException("Could not fetch IFrame resource", e);
        }
        try {
            String hash = Parser.matchGroup1(IFRAME_RES_JS_BASE_PLAYER_HASH_PATTERN, iframeContent);
            return String.format(BASE_JS_PLAYER_URL_FORMAT, hash);
        }
        catch (Parser.RegexException e) {
            throw new ParsingException("IFrame resource didn't provide JavaScript base player's hash", e);
        }
    }

    @Nonnull
    static String extractJavaScriptUrlWithEmbedWatchPage(@Nonnull String videoId) throws ParsingException {
        String embedPageContent;
        try {
            String embedUrl = "https://www.youtube.com/embed/" + videoId;
            embedPageContent = NewPipe.getDownloader().get(embedUrl, Localization.DEFAULT).responseBody();
        }
        catch (Exception e) {
            throw new ParsingException("Could not fetch embedded watch page", e);
        }
        Document doc = Jsoup.parse(embedPageContent);
        Elements elems = doc.select("script").attr("name", "player/base");
        for (Element elem : elems) {
            String playerUrl = elem.attr("src");
            if (!playerUrl.contains("base.js")) continue;
            return playerUrl;
        }
        try {
            return Parser.matchGroup1(EMBEDDED_WATCH_PAGE_JS_BASE_PLAYER_URL_PATTERN, embedPageContent);
        }
        catch (Parser.RegexException e) {
            throw new ParsingException("Embedded watch page didn't provide JavaScript base player's URL", e);
        }
    }

    @Nonnull
    private static String cleanJavaScriptUrl(@Nonnull String javaScriptPlayerUrl) {
        if (javaScriptPlayerUrl.startsWith("//")) {
            return HTTPS + javaScriptPlayerUrl;
        }
        if (javaScriptPlayerUrl.startsWith("/")) {
            return "https://www.youtube.com" + javaScriptPlayerUrl;
        }
        return javaScriptPlayerUrl;
    }

    @Nonnull
    private static String downloadJavaScriptCode(@Nonnull String javaScriptPlayerUrl) throws ParsingException {
        try {
            return NewPipe.getDownloader().get(javaScriptPlayerUrl, Localization.DEFAULT).responseBody();
        }
        catch (Exception e) {
            throw new ParsingException("Could not get JavaScript base player's code", e);
        }
    }
}

