/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors.SoundcloudCommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudCommentsExtractor
extends CommentsExtractor {
    public SoundcloudCommentsExtractor(StreamingService service, ListLinkHandler uiHandler) {
        super(service, uiHandler);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getInitialPage() throws ExtractionException, IOException {
        return this.getPage(this.getUrl());
    }

    @Override
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getPage(Page page) throws ExtractionException, IOException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        return this.getPage(page.getUrl());
    }

    @Nonnull
    private ListExtractor.InfoItemsPage<CommentsInfoItem> getPage(@Nonnull String url) throws ParsingException, IOException, ReCaptchaException {
        JsonObject json;
        Downloader downloader = NewPipe.getDownloader();
        Response response = downloader.get(url);
        try {
            json = JsonParser.object().from(response.responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse json", e);
        }
        CommentsInfoItemsCollector collector = new CommentsInfoItemsCollector(this.getServiceId());
        this.collectStreamsFrom(collector, json.getArray("collection"));
        return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, new Page(json.getString("next_href", null)));
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) {
    }

    private void collectStreamsFrom(CommentsInfoItemsCollector collector, JsonArray entries) throws ParsingException {
        String url = this.getUrl();
        for (Object comment : entries) {
            collector.commit(new SoundcloudCommentsInfoItemExtractor((JsonObject)comment, url));
        }
    }
}

