/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.io.IOException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.tabs.ChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudChannelTabExtractor
extends ChannelTabExtractor {
    private static final String USERS_ENDPOINT = "https://api-v2.soundcloud.com/users/";
    private final String userId = this.getLinkHandler().getId();

    public SoundcloudChannelTabExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Nonnull
    private String getEndpoint() throws ParsingException {
        switch (this.getName()) {
            case "tracks": {
                return "/tracks";
            }
            case "playlists": {
                return "/playlists_without_albums";
            }
            case "albums": {
                return "/albums";
            }
            case "likes": {
                return "/likes";
            }
        }
        throw new ParsingException("Unsupported tab: " + this.getName());
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) {
    }

    @Override
    @Nonnull
    public String getId() {
        return this.userId;
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        return this.getPage(new Page(USERS_ENDPOINT + this.userId + this.getEndpoint() + "?client_id=" + SoundcloudParsingHelper.clientId() + "&limit=20&linked_partitioning=1"));
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
        String nextPageUrl = SoundcloudParsingHelper.getInfoItemsFromApi(collector, page.getUrl());
        return new ListExtractor.InfoItemsPage<InfoItem>(collector, new Page(nextPageUrl));
    }
}

