/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.UnsupportedTabException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeChannelLinkHandlerFactory;

public final class PeertubeChannelTabLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final PeertubeChannelTabLinkHandlerFactory INSTANCE = new PeertubeChannelTabLinkHandlerFactory();

    private PeertubeChannelTabLinkHandlerFactory() {
    }

    public static PeertubeChannelTabLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static String getUrlSuffix(@Nonnull String tab) throws UnsupportedTabException {
        switch (tab) {
            case "videos": {
                return "/videos";
            }
            case "channels": {
                return "/video-channels";
            }
            case "playlists": {
                return "/video-playlists";
            }
        }
        throw new UnsupportedTabException(tab);
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return PeertubeChannelLinkHandlerFactory.getInstance().getId(url);
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return PeertubeChannelLinkHandlerFactory.getInstance().getUrl(id2) + PeertubeChannelTabLinkHandlerFactory.getUrlSuffix(contentFilter.get(0));
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        return PeertubeChannelLinkHandlerFactory.getInstance().getUrl(id2, null, null, baseUrl) + PeertubeChannelTabLinkHandlerFactory.getUrlSuffix(contentFilter.get(0));
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        return PeertubeChannelLinkHandlerFactory.getInstance().onAcceptUrl(url);
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{"videos", "channels", "playlists"};
    }
}

