/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ServiceList;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Parser;

public final class PeertubeChannelLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final PeertubeChannelLinkHandlerFactory INSTANCE = new PeertubeChannelLinkHandlerFactory();
    private static final String ID_PATTERN = "((accounts|a)|(video-channels|c))/([^/?&#]*)";
    private static final String ID_URL_PATTERN = "/((accounts|a)|(video-channels|c))/([^/?&#]*)";
    public static final String API_ENDPOINT = "/api/v1/";

    private PeertubeChannelLinkHandlerFactory() {
    }

    public static PeertubeChannelLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return this.fixId(Parser.matchGroup(ID_URL_PATTERN, url, 0));
    }

    @Override
    public String getUrl(String id2, List<String> contentFilters, String searchFilter) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, contentFilters, searchFilter, ServiceList.PeerTube.getBaseUrl());
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        if (id2.matches(ID_PATTERN)) {
            return baseUrl + "/" + this.fixId(id2);
        }
        return baseUrl + "/accounts/" + id2;
    }

    @Override
    public boolean onAcceptUrl(String url) {
        try {
            new URL(url);
            return url.contains("/accounts/") || url.contains("/a/") || url.contains("/video-channels/") || url.contains("/c/");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private String fixId(@Nonnull String id2) {
        String cleanedId;
        String string = cleanedId = id2.startsWith("/") ? id2.substring(1) : id2;
        if (cleanedId.startsWith("a/")) {
            return "accounts" + cleanedId.substring(1);
        }
        if (cleanedId.startsWith("c/")) {
            return "video-channels" + cleanedId.substring(1);
        }
        return cleanedId;
    }
}

