/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubePlaylistExtractor
extends PlaylistExtractor {
    private JsonObject playlistInfo;

    public PeertubePlaylistExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return PeertubeParsingHelper.getThumbnailsFromPlaylistOrVideoItem(this.getBaseUrl(), this.playlistInfo);
    }

    @Override
    public String getUploaderUrl() {
        return this.playlistInfo.getObject("ownerAccount").getString("url");
    }

    @Override
    public String getUploaderName() {
        return this.playlistInfo.getObject("ownerAccount").getString("displayName");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.getBaseUrl(), this.playlistInfo.getObject("ownerAccount"));
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() {
        return this.playlistInfo.getLong("videosLength");
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        String description = this.playlistInfo.getString("description");
        if (Utils.isNullOrEmpty(description)) {
            return Description.EMPTY_DESCRIPTION;
        }
        return new Description(description, 3);
    }

    @Override
    @Nonnull
    public String getSubChannelName() {
        return this.playlistInfo.getObject("videoChannel").getString("displayName");
    }

    @Override
    @Nonnull
    public String getSubChannelUrl() {
        return this.playlistInfo.getObject("videoChannel").getString("url");
    }

    @Override
    @Nonnull
    public List<Image> getSubChannelAvatars() throws ParsingException {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.getBaseUrl(), this.playlistInfo.getObject("videoChannel"));
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        return this.getPage(new Page(this.getUrl() + "/videos?start=0&count=12"));
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        Response response = this.getDownloader().get(page.getUrl());
        JsonObject json = null;
        if (response != null && !Utils.isBlank(response.responseBody())) {
            try {
                json = JsonParser.object().from(response.responseBody());
            }
            catch (Exception e) {
                throw new ParsingException("Could not parse json data for playlist info", e);
            }
        }
        if (json != null) {
            PeertubeParsingHelper.validate(json);
            long total = json.getLong("total");
            StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
            PeertubeParsingHelper.collectItemsFrom(collector, json, this.getBaseUrl());
            return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, PeertubeParsingHelper.getNextPage(page.getUrl(), total));
        }
        throw new ExtractionException("Unable to get PeerTube playlist info");
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Response response = downloader.get(this.getUrl());
        try {
            this.playlistInfo = JsonParser.object().from(response.responseBody());
        }
        catch (JsonParserException jpe) {
            throw new ExtractionException("Could not parse json", jpe);
        }
        PeertubeParsingHelper.validate(this.playlistInfo);
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.playlistInfo.getString("displayName");
    }
}

