/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.linkHandler.PeertubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class PeertubeAccountExtractor
extends ChannelExtractor {
    private JsonObject json;
    private final String baseUrl = this.getBaseUrl();
    private static final String ACCOUNTS = "accounts/";

    public PeertubeAccountExtractor(StreamingService service, ListLinkHandler linkHandler) throws ParsingException {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() {
        return PeertubeParsingHelper.getAvatarsFromOwnerAccountOrVideoChannelObject(this.baseUrl, this.json);
    }

    @Override
    @Nonnull
    public List<Image> getBanners() {
        return PeertubeParsingHelper.getBannersFromAccountOrVideoChannelObject(this.baseUrl, this.json);
    }

    @Override
    public String getFeedUrl() throws ParsingException {
        return this.getBaseUrl() + "/feeds/videos.xml?accountId=" + this.json.get("id");
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        long subscribersCount = this.json.getLong("followersCount");
        String accountVideoChannelUrl = this.baseUrl + "/api/v1/";
        accountVideoChannelUrl = this.getId().contains(ACCOUNTS) ? accountVideoChannelUrl + this.getId() : accountVideoChannelUrl + ACCOUNTS + this.getId();
        accountVideoChannelUrl = accountVideoChannelUrl + "/video-channels";
        try {
            String responseBody = this.getDownloader().get(accountVideoChannelUrl).responseBody();
            JsonObject jsonResponse = JsonParser.object().from(responseBody);
            JsonArray videoChannels = jsonResponse.getArray("data");
            for (Object videoChannel : videoChannels) {
                JsonObject videoChannelJsonObject = (JsonObject)videoChannel;
                subscribersCount += (long)videoChannelJsonObject.getInt("followersCount");
            }
        }
        catch (IOException | JsonParserException | ReCaptchaException exception) {
            // empty catch block
        }
        return subscribersCount;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.json.getString("description");
    }

    @Override
    public String getParentChannelName() {
        return "";
    }

    @Override
    public String getParentChannelUrl() {
        return "";
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return List.of();
    }

    @Override
    public boolean isVerified() throws ParsingException {
        return false;
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        return List.of(PeertubeChannelTabLinkHandlerFactory.getInstance().fromQuery(this.getId(), List.of("videos"), "", this.getBaseUrl()), PeertubeChannelTabLinkHandlerFactory.getInstance().fromQuery(this.getId(), List.of("channels"), "", this.getBaseUrl()));
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Response response = downloader.get(this.baseUrl + "/api/v1/" + this.getId());
        if (response == null) {
            throw new ExtractionException("Unable to extract PeerTube account data");
        }
        this.setInitialData(response.responseBody());
    }

    private void setInitialData(String responseBody) throws ExtractionException {
        try {
            this.json = JsonParser.object().from(responseBody);
        }
        catch (JsonParserException e) {
            throw new ExtractionException("Unable to extract PeerTube account data", e);
        }
        if (this.json == null) {
            throw new ExtractionException("Unable to extract PeerTube account data");
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return JsonUtils.getString(this.json, "displayName");
    }
}

