/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube;

import java.io.IOException;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubeInstance {
    private final String url;
    private String name;
    public static final PeertubeInstance DEFAULT_INSTANCE = new PeertubeInstance("https://framatube.org", "FramaTube");

    public PeertubeInstance(String url) {
        this.url = url;
        this.name = "PeerTube";
    }

    public PeertubeInstance(String url, String name) {
        this.url = url;
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void fetchInstanceMetaData() throws Exception {
        Response response;
        try {
            response = NewPipe.getDownloader().get(this.url + "/api/v1/config");
        }
        catch (IOException | ReCaptchaException e) {
            throw new Exception("unable to configure instance " + this.url, e);
        }
        if (response == null || Utils.isBlank(response.responseBody())) {
            throw new Exception("unable to configure instance " + this.url);
        }
        try {
            JsonObject json = JsonParser.object().from(response.responseBody());
            this.name = JsonUtils.getString(json, "instance.name");
        }
        catch (JsonParserException | ParsingException e) {
            throw new Exception("unable to parse instance config", e);
        }
    }

    public String getName() {
        return this.name;
    }
}

