/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.MediaFormat;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.AudioStream;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamType;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.VideoStream;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.LocaleCompat;

public class MediaCCCStreamExtractor
extends StreamExtractor {
    private JsonObject data;
    private JsonObject conferenceData;

    public MediaCCCStreamExtractor(StreamingService service, LinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    @Nonnull
    public String getTextualUploadDate() {
        return this.data.getString("release_date");
    }

    @Override
    @Nonnull
    public DateWrapper getUploadDate() throws ParsingException {
        return new DateWrapper(MediaCCCParsingHelper.parseDateFrom(this.getTextualUploadDate()));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return MediaCCCParsingHelper.getThumbnailsFromStreamItem(this.data);
    }

    @Override
    @Nonnull
    public Description getDescription() {
        return new Description(this.data.getString("description"), 3);
    }

    @Override
    public long getLength() {
        return this.data.getInt("length");
    }

    @Override
    public long getViewCount() {
        return this.data.getInt("view_count");
    }

    @Override
    @Nonnull
    public String getUploaderUrl() {
        return "https://media.ccc.de/c/" + this.getUploaderName();
    }

    @Override
    @Nonnull
    public String getUploaderName() {
        return this.data.getString("conference_url").replaceFirst("https://(api\\.)?media\\.ccc\\.de/public/conferences/", "");
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return MediaCCCParsingHelper.getImageListFromLogoImageUrl(this.conferenceData.getString("logo_url"));
    }

    @Override
    public List<AudioStream> getAudioStreams() throws ExtractionException {
        JsonArray recordings = this.data.getArray("recordings");
        ArrayList<AudioStream> audioStreams = new ArrayList<AudioStream>();
        for (int i = 0; i < recordings.size(); ++i) {
            JsonObject recording = recordings.getObject(i);
            String mimeType = recording.getString("mime_type");
            if (!mimeType.startsWith("audio")) continue;
            MediaFormat mediaFormat = mimeType.endsWith("opus") ? MediaFormat.OPUS : (mimeType.endsWith("mpeg") ? MediaFormat.MP3 : (mimeType.endsWith("ogg") ? MediaFormat.OGG : null));
            AudioStream.Builder builder = new AudioStream.Builder().setId(recording.getString("filename", " ")).setContent(recording.getString("recording_url"), true).setMediaFormat(mediaFormat).setAverageBitrate(-1);
            String language = recording.getString("language");
            if (language != null && !language.contains("-")) {
                builder.setAudioLocale(LocaleCompat.forLanguageTag(language).orElseThrow(() -> new ParsingException("Cannot convert this language to a locale: " + language)));
            }
            audioStreams.add(builder.build());
        }
        return audioStreams;
    }

    @Override
    public List<VideoStream> getVideoStreams() throws ExtractionException {
        JsonArray recordings = this.data.getArray("recordings");
        ArrayList<VideoStream> videoStreams = new ArrayList<VideoStream>();
        for (int i = 0; i < recordings.size(); ++i) {
            JsonObject recording = recordings.getObject(i);
            String mimeType = recording.getString("mime_type");
            if (!mimeType.startsWith("video")) continue;
            MediaFormat mediaFormat = mimeType.endsWith("webm") ? MediaFormat.WEBM : (mimeType.endsWith("mp4") ? MediaFormat.MPEG_4 : null);
            videoStreams.add(new VideoStream.Builder().setId(recording.getString("filename", " ")).setContent(recording.getString("recording_url"), true).setIsVideoOnly(false).setMediaFormat(mediaFormat).setResolution(recording.getInt("height") + "p").build());
        }
        return videoStreams;
    }

    @Override
    public List<VideoStream> getVideoOnlyStreams() {
        return Collections.emptyList();
    }

    @Override
    public StreamType getStreamType() {
        return StreamType.VIDEO_STREAM;
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String videoUrl = "https://api.media.ccc.de/public/events/" + this.getId();
        try {
            this.data = JsonParser.object().from(downloader.get(videoUrl).responseBody());
            this.conferenceData = JsonParser.object().from(downloader.get(this.data.getString("conference_url")).responseBody());
        }
        catch (JsonParserException jpe) {
            throw new ExtractionException("Could not parse json returned by URL: " + videoUrl, jpe);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.data.getString("title");
    }

    @Override
    @Nonnull
    public String getOriginalUrl() {
        return this.data.getString("frontend_link");
    }

    @Override
    public Locale getLanguageInfo() throws ParsingException {
        return Localization.getLocaleFromThreeLetterCode(this.data.getString("original_language"));
    }

    @Override
    @Nonnull
    public List<String> getTags() {
        return JsonUtils.getStringListFromJsonArray(this.data.getArray("tags"));
    }
}

