/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ReadyChannelTabListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.media_ccc.extractors.MediaCCCParsingHelper;

public class MediaCCCConferenceExtractor
extends ChannelExtractor {
    private JsonObject conferenceData;

    public MediaCCCConferenceExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    static JsonObject fetchConferenceData(@Nonnull Downloader downloader, @Nonnull String conferenceId) throws IOException, ExtractionException {
        String conferenceUrl = "https://api.media.ccc.de/public/conferences/" + conferenceId;
        try {
            return JsonParser.object().from(downloader.get(conferenceUrl).responseBody());
        }
        catch (JsonParserException jpe) {
            throw new ExtractionException("Could not parse json returned by URL: " + conferenceUrl);
        }
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() {
        return MediaCCCParsingHelper.getImageListFromLogoImageUrl(this.conferenceData.getString("logo_url"));
    }

    @Override
    @Nonnull
    public List<Image> getBanners() {
        return Collections.emptyList();
    }

    @Override
    public String getFeedUrl() {
        return null;
    }

    @Override
    public long getSubscriberCount() {
        return -1L;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getParentChannelName() {
        return "";
    }

    @Override
    public String getParentChannelUrl() {
        return "";
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return Collections.emptyList();
    }

    @Override
    public boolean isVerified() {
        return false;
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        JsonObject theConferenceData = this.conferenceData;
        return List.of(new ReadyChannelTabListLinkHandler(this.getUrl(), this.getId(), "videos", (service, linkHandler) -> new MediaCCCChannelTabExtractor(service, linkHandler, theConferenceData)));
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.conferenceData = MediaCCCConferenceExtractor.fetchConferenceData(downloader, this.getId());
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return this.conferenceData.getString("title");
    }
}

