/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler;

import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class BandcampFeaturedLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final BandcampFeaturedLinkHandlerFactory INSTANCE = new BandcampFeaturedLinkHandlerFactory();

    private BandcampFeaturedLinkHandlerFactory() {
    }

    public static BandcampFeaturedLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        if (id2.equals("Featured")) {
            return "https://bandcamp.com/api/mobile/24/bootstrap_data";
        }
        if (id2.equals("Radio")) {
            return "https://bandcamp.com/api/bcweekly/3/list";
        }
        return null;
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        String fixedUrl = Utils.replaceHttpWithHttps(url);
        if (BandcampExtractorHelper.isRadioUrl(fixedUrl) || fixedUrl.equals("https://bandcamp.com/api/bcweekly/3/list")) {
            return "Radio";
        }
        if (fixedUrl.equals("https://bandcamp.com/api/mobile/24/bootstrap_data")) {
            return "Featured";
        }
        return null;
    }

    @Override
    public boolean onAcceptUrl(String url) {
        String fixedUrl = Utils.replaceHttpWithHttps(url);
        return fixedUrl.equals("https://bandcamp.com/api/mobile/24/bootstrap_data") || fixedUrl.equals("https://bandcamp.com/api/bcweekly/3/list") || BandcampExtractorHelper.isRadioUrl(fixedUrl);
    }
}

