/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.UnsupportedTabException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.linkHandler.BandcampChannelLinkHandlerFactory;

public final class BandcampChannelTabLinkHandlerFactory
extends ListLinkHandlerFactory {
    private static final BandcampChannelTabLinkHandlerFactory INSTANCE = new BandcampChannelTabLinkHandlerFactory();

    private BandcampChannelTabLinkHandlerFactory() {
    }

    public static BandcampChannelTabLinkHandlerFactory getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static String getUrlSuffix(@Nonnull String tab) throws UnsupportedTabException {
        switch (tab) {
            case "tracks": {
                return "/track";
            }
            case "albums": {
                return "/album";
            }
        }
        throw new UnsupportedTabException(tab);
    }

    @Override
    public String getId(String url) throws ParsingException, UnsupportedOperationException {
        return BandcampChannelLinkHandlerFactory.getInstance().getId(url);
    }

    @Override
    public String getUrl(String id2, List<String> contentFilter, String sortFilter) throws ParsingException, UnsupportedOperationException {
        return BandcampChannelLinkHandlerFactory.getInstance().getUrl(id2) + BandcampChannelTabLinkHandlerFactory.getUrlSuffix(contentFilter.get(0));
    }

    @Override
    public boolean onAcceptUrl(String url) throws ParsingException {
        return BandcampChannelLinkHandlerFactory.getInstance().onAcceptUrl(url);
    }

    @Override
    public String[] getAvailableContentFilter() {
        return new String[]{"tracks", "albums"};
    }
}

