/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem;

import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.nodes.Element;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampStreamInfoItemExtractor;

public class BandcampSearchStreamInfoItemExtractor
extends BandcampStreamInfoItemExtractor {
    private final Element resultInfo;
    private final Element searchResult;

    public BandcampSearchStreamInfoItemExtractor(Element searchResult, String uploaderUrl) {
        super(uploaderUrl);
        this.searchResult = searchResult;
        this.resultInfo = searchResult.getElementsByClass("result-info").first();
    }

    @Override
    public String getUploaderName() {
        String subhead = this.resultInfo.getElementsByClass("subhead").text();
        String[] splitBy = subhead.split("by ");
        if (splitBy.length > 1) {
            return splitBy[1];
        }
        return splitBy[0];
    }

    @Override
    public String getName() throws ParsingException {
        return this.resultInfo.getElementsByClass("heading").text();
    }

    @Override
    public String getUrl() throws ParsingException {
        return this.resultInfo.getElementsByClass("itemurl").text();
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return BandcampExtractorHelper.getImagesFromSearchResult(this.searchResult);
    }

    @Override
    public long getDuration() {
        return -1L;
    }
}

