/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.streaminfoitem.BandcampStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamExtractor;

public class BandcampPlaylistStreamInfoItemExtractor
extends BandcampStreamInfoItemExtractor {
    private final JsonObject track;
    private List<Image> substituteCovers;
    private final StreamingService service;

    public BandcampPlaylistStreamInfoItemExtractor(JsonObject track, String uploaderUrl, StreamingService service) {
        super(uploaderUrl);
        this.track = track;
        this.service = service;
        this.substituteCovers = Collections.emptyList();
    }

    public BandcampPlaylistStreamInfoItemExtractor(JsonObject track, String uploaderUrl, List<Image> substituteCovers) {
        this(track, uploaderUrl, (StreamingService)null);
        this.substituteCovers = substituteCovers;
    }

    @Override
    public String getName() {
        return this.track.getString("title");
    }

    @Override
    public String getUrl() {
        String relativeUrl = this.track.getString("title_link");
        if (relativeUrl != null) {
            return this.getUploaderUrl() + relativeUrl;
        }
        return null;
    }

    @Override
    public long getDuration() {
        return this.track.getLong("duration");
    }

    @Override
    public String getUploaderName() {
        return "";
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        if (this.substituteCovers.isEmpty() && this.getUrl() != null) {
            try {
                StreamExtractor extractor = this.service.getStreamExtractor(this.getUrl());
                extractor.fetchPage();
                return extractor.getThumbnails();
            }
            catch (IOException | ExtractionException e) {
                throw new ParsingException("Could not download cover art location", e);
            }
        }
        return this.substituteCovers;
    }
}

