/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampRadioInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;

public class BandcampRadioExtractor
extends KioskExtractor<StreamInfoItem> {
    public static final String KIOSK_RADIO = "Radio";
    public static final String RADIO_API_URL = "https://bandcamp.com/api/bcweekly/3/list";
    private JsonObject json = null;

    public BandcampRadioExtractor(StreamingService streamingService, ListLinkHandler linkHandler, String kioskId) {
        super(streamingService, linkHandler, kioskId);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        try {
            this.json = JsonParser.object().from(this.getDownloader().get(RADIO_API_URL).responseBody());
        }
        catch (JsonParserException e) {
            throw new ExtractionException("Could not parse Bandcamp Radio API response", e);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return KIOSK_RADIO;
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        JsonArray radioShows = this.json.getArray("results");
        for (int i = 0; i < radioShows.size(); ++i) {
            JsonObject radioShow = radioShows.getObject(i);
            collector.commit(new BandcampRadioInfoItemExtractor(radioShow));
        }
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, null);
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) {
        return null;
    }
}

