/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.com.grack.nanojson.JsonParserException;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.kiosk.KioskExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampPlaylistInfoItemFeaturedExtractor;

public class BandcampFeaturedExtractor
extends KioskExtractor<PlaylistInfoItem> {
    public static final String KIOSK_FEATURED = "Featured";
    public static final String FEATURED_API_URL = "https://bandcamp.com/api/mobile/24/bootstrap_data";
    public static final String MORE_FEATURED_API_URL = "https://bandcamp.com/api/mobile/24/feed_older_logged_out";
    private JsonObject json;

    public BandcampFeaturedExtractor(StreamingService streamingService, ListLinkHandler listLinkHandler, String kioskId) {
        super(streamingService, listLinkHandler, kioskId);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        try {
            this.json = JsonParser.object().from(this.getDownloader().postWithContentTypeJson(FEATURED_API_URL, Collections.emptyMap(), "{\"platform\":\"\",\"version\":0}".getBytes(StandardCharsets.UTF_8)).responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse Bandcamp featured API response", e);
        }
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        return KIOSK_FEATURED;
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<PlaylistInfoItem> getInitialPage() throws IOException, ExtractionException {
        JsonArray featuredStories = this.json.getObject("feed_content").getObject("stories").getArray("featured");
        return this.extractItems(featuredStories);
    }

    private ListExtractor.InfoItemsPage<PlaylistInfoItem> extractItems(JsonArray featuredStories) {
        PlaylistInfoItemsCollector c = new PlaylistInfoItemsCollector(this.getServiceId());
        for (int i = 0; i < featuredStories.size(); ++i) {
            JsonObject featuredStory = featuredStories.getObject(i);
            if (featuredStory.isNull("album_title")) continue;
            c.commit(new BandcampPlaylistInfoItemFeaturedExtractor(featuredStory));
        }
        JsonObject lastFeaturedStory = featuredStories.getObject(featuredStories.size() - 1);
        return new ListExtractor.InfoItemsPage<PlaylistInfoItem>(c, this.getNextPageFrom(lastFeaturedStory));
    }

    private Page getNextPageFrom(JsonObject lastFeaturedStory) {
        long lastStoryDate = lastFeaturedStory.getLong("story_date");
        long lastStoryId = lastFeaturedStory.getLong("ntid");
        String lastStoryType = lastFeaturedStory.getString("story_type");
        return new Page("https://bandcamp.com/api/mobile/24/feed_older_logged_out?story_groups=featured:" + lastStoryDate + ":" + lastStoryType + ":" + lastStoryId);
    }

    @Override
    public ListExtractor.InfoItemsPage<PlaylistInfoItem> getPage(Page page) throws IOException, ExtractionException {
        JsonObject response;
        try {
            response = JsonParser.object().from(this.getDownloader().get(page.getUrl()).responseBody());
        }
        catch (JsonParserException e) {
            throw new ParsingException("Could not parse Bandcamp featured API response", e);
        }
        return this.extractItems(response.getObject("stories").getArray("featured"));
    }
}

