/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.localization;

import java.time.OffsetDateTime;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.timeago.PatternsHolder;
import org.watermedia.shaded.schabi.newpipe.extractor.timeago.PatternsManager;

public final class TimeAgoPatternsManager {
    private TimeAgoPatternsManager() {
    }

    @Nullable
    private static PatternsHolder getPatternsFor(@Nonnull Localization localization) {
        return PatternsManager.getPatterns(localization.getLanguageCode(), localization.getCountryCode());
    }

    @Nullable
    public static TimeAgoParser getTimeAgoParserFor(@Nonnull Localization localization) {
        PatternsHolder holder = TimeAgoPatternsManager.getPatternsFor(localization);
        if (holder == null) {
            return null;
        }
        return new TimeAgoParser(holder);
    }

    @Nullable
    public static TimeAgoParser getTimeAgoParserFor(@Nonnull Localization localization, @Nonnull OffsetDateTime now) {
        PatternsHolder holder = TimeAgoPatternsManager.getPatternsFor(localization);
        if (holder == null) {
            return null;
        }
        return new TimeAgoParser(holder, now);
    }
}

