/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.linkhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public abstract class ListLinkHandlerFactory
extends LinkHandlerFactory {
    public abstract String getUrl(String var1, List<String> var2, String var3) throws ParsingException, UnsupportedOperationException;

    public String getUrl(String id2, List<String> contentFilter, String sortFilter, String baseUrl) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, contentFilter, sortFilter);
    }

    @Override
    public ListLinkHandler fromUrl(String url) throws ParsingException {
        String polishedUrl = Utils.followGoogleRedirectIfNeeded(url);
        String baseUrl = Utils.getBaseUrl(polishedUrl);
        return this.fromUrl(polishedUrl, baseUrl);
    }

    @Override
    public ListLinkHandler fromUrl(String url, String baseUrl) throws ParsingException {
        Objects.requireNonNull(url, "URL may not be null");
        return new ListLinkHandler(super.fromUrl(url, baseUrl));
    }

    @Override
    public ListLinkHandler fromId(String id2) throws ParsingException {
        return new ListLinkHandler(super.fromId(id2));
    }

    @Override
    public ListLinkHandler fromId(String id2, String baseUrl) throws ParsingException {
        return new ListLinkHandler(super.fromId(id2, baseUrl));
    }

    public ListLinkHandler fromQuery(String id2, List<String> contentFilters, String sortFilter) throws ParsingException {
        String url = this.getUrl(id2, contentFilters, sortFilter);
        return new ListLinkHandler(url, url, id2, contentFilters, sortFilter);
    }

    public ListLinkHandler fromQuery(String id2, List<String> contentFilters, String sortFilter, String baseUrl) throws ParsingException {
        String url = this.getUrl(id2, contentFilters, sortFilter, baseUrl);
        return new ListLinkHandler(url, url, id2, contentFilters, sortFilter);
    }

    @Override
    public String getUrl(String id2) throws ParsingException, UnsupportedOperationException {
        return this.getUrl(id2, new ArrayList<String>(0), "");
    }

    @Override
    public String getUrl(String id2, String baseUrl) throws ParsingException {
        return this.getUrl(id2, new ArrayList<String>(0), "", baseUrl);
    }

    public String[] getAvailableContentFilter() {
        return new String[0];
    }

    public String[] getAvailableSortFilter() {
        return new String[0];
    }
}

