/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.downloader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;

public class Response {
    private final int responseCode;
    private final String responseMessage;
    private final Map<String, List<String>> responseHeaders;
    private final String responseBody;
    private final String latestUrl;

    public Response(int responseCode, String responseMessage, @Nullable Map<String, List<String>> responseHeaders, @Nullable String responseBody, @Nullable String latestUrl) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.responseHeaders = responseHeaders == null ? Collections.emptyMap() : responseHeaders;
        this.responseBody = responseBody == null ? "" : responseBody;
        this.latestUrl = latestUrl;
    }

    public int responseCode() {
        return this.responseCode;
    }

    public String responseMessage() {
        return this.responseMessage;
    }

    public Map<String, List<String>> responseHeaders() {
        return this.responseHeaders;
    }

    @Nonnull
    public String responseBody() {
        return this.responseBody;
    }

    @Nonnull
    public String latestUrl() {
        return this.latestUrl;
    }

    @Nullable
    public String getHeader(String name) {
        for (Map.Entry<String, List<String>> headerEntry : this.responseHeaders.entrySet()) {
            String key = headerEntry.getKey();
            if (key == null || !key.equalsIgnoreCase(name) || headerEntry.getValue().isEmpty()) continue;
            return headerEntry.getValue().get(0);
        }
        return null;
    }
}

