/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.downloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;

public class Request {
    private final String httpMethod;
    private final String url;
    private final Map<String, List<String>> headers;
    @Nullable
    private final byte[] dataToSend;
    @Nullable
    private final Localization localization;

    public Request(String httpMethod, String url, @Nullable Map<String, List<String>> headers, @Nullable byte[] dataToSend, @Nullable Localization localization, boolean automaticLocalizationHeader) {
        this.httpMethod = Objects.requireNonNull(httpMethod, "Request's httpMethod is null");
        this.url = Objects.requireNonNull(url, "Request's url is null");
        this.dataToSend = dataToSend;
        this.localization = localization;
        LinkedHashMap<String, List<String>> actualHeaders = new LinkedHashMap<String, List<String>>();
        if (headers != null) {
            actualHeaders.putAll(headers);
        }
        if (automaticLocalizationHeader && localization != null) {
            actualHeaders.putAll(Request.getHeadersFromLocalization(localization));
        }
        this.headers = Collections.unmodifiableMap(actualHeaders);
    }

    private Request(Builder builder) {
        this(builder.httpMethod, builder.url, builder.headers, builder.dataToSend, builder.localization, builder.automaticLocalizationHeader);
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String url() {
        return this.url;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Nullable
    public byte[] dataToSend() {
        return this.dataToSend;
    }

    @Nullable
    public Localization localization() {
        return this.localization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static Map<String, List<String>> getHeadersFromLocalization(@Nullable Localization localization) {
        if (localization == null) {
            return Collections.emptyMap();
        }
        String languageCode = localization.getLanguageCode();
        List<String> languageCodeList = Collections.singletonList(localization.getCountryCode().isEmpty() ? languageCode : localization.getLocalizationCode() + ", " + languageCode + ";q=0.9");
        return Collections.singletonMap("Accept-Language", languageCodeList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return this.httpMethod.equals(request.httpMethod) && this.url.equals(request.url) && this.headers.equals(request.headers) && Arrays.equals(this.dataToSend, request.dataToSend) && Objects.equals(this.localization, request.localization);
    }

    public int hashCode() {
        int result = Objects.hash(this.httpMethod, this.url, this.headers, this.localization);
        result = 31 * result + Arrays.hashCode(this.dataToSend);
        return result;
    }

    public static final class Builder {
        private String httpMethod;
        private String url;
        private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private byte[] dataToSend;
        private Localization localization;
        private boolean automaticLocalizationHeader = true;

        public Builder httpMethod(String httpMethodToSet) {
            this.httpMethod = httpMethodToSet;
            return this;
        }

        public Builder url(String urlToSet) {
            this.url = urlToSet;
            return this;
        }

        public Builder headers(@Nullable Map<String, List<String>> headersToSet) {
            this.headers.clear();
            if (headersToSet != null) {
                this.headers.putAll(headersToSet);
            }
            return this;
        }

        public Builder dataToSend(byte[] dataToSendToSet) {
            this.dataToSend = dataToSendToSet;
            return this;
        }

        public Builder localization(Localization localizationToSet) {
            this.localization = localizationToSet;
            return this;
        }

        public Builder automaticLocalizationHeader(boolean automaticLocalizationHeaderToSet) {
            this.automaticLocalizationHeader = automaticLocalizationHeaderToSet;
            return this;
        }

        public Request build() {
            return new Request(this);
        }

        public Builder get(String urlToSet) {
            this.httpMethod = "GET";
            this.url = urlToSet;
            return this;
        }

        public Builder head(String urlToSet) {
            this.httpMethod = "HEAD";
            this.url = urlToSet;
            return this;
        }

        public Builder post(String urlToSet, @Nullable byte[] dataToSendToSet) {
            this.httpMethod = "POST";
            this.url = urlToSet;
            this.dataToSend = dataToSendToSet;
            return this;
        }

        public Builder setHeaders(String headerName, List<String> headerValueList) {
            this.headers.remove(headerName);
            this.headers.put(headerName, headerValueList);
            return this;
        }

        public Builder addHeaders(String headerName, List<String> headerValueList) {
            List<String> currentHeaderValueList = this.headers.get(headerName);
            if (currentHeaderValueList == null) {
                currentHeaderValueList = new ArrayList<String>();
            }
            currentHeaderValueList.addAll(headerValueList);
            this.headers.put(headerName, headerValueList);
            return this;
        }

        public Builder setHeader(String headerName, String headerValue) {
            return this.setHeaders(headerName, Collections.singletonList(headerValue));
        }

        public Builder addHeader(String headerName, String headerValue) {
            return this.addHeaders(headerName, Collections.singletonList(headerValue));
        }
    }
}

